/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.flagengine;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.flagsmith.flagengine.SegmentCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "conditions", "rules"})
public class SegmentRule {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Segment rule type. Represents a logical quantifier for the conditions and sub-rules.")
    private Type type;
    @JsonProperty(value="conditions")
    @JsonPropertyDescription(value="Conditions that must be met for the rule to apply.")
    private List<SegmentCondition> conditions = new ArrayList<SegmentCondition>();
    @JsonProperty(value="rules")
    @JsonPropertyDescription(value="Sub-rules nested within the segment rule.")
    private List<SegmentRule> rules = new ArrayList<SegmentRule>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public SegmentRule() {
    }

    public SegmentRule(SegmentRule source) {
        this.type = source.type;
        this.conditions = source.conditions;
        this.rules = source.rules;
    }

    public SegmentRule(Type type, List<SegmentCondition> conditions, List<SegmentRule> rules) {
        this.type = type;
        this.conditions = conditions;
        this.rules = rules;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    public SegmentRule withType(Type type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="conditions")
    public List<SegmentCondition> getConditions() {
        return this.conditions;
    }

    @JsonProperty(value="conditions")
    public void setConditions(List<SegmentCondition> conditions) {
        this.conditions = conditions;
    }

    public SegmentRule withConditions(List<SegmentCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    @JsonProperty(value="rules")
    public List<SegmentRule> getRules() {
        return this.rules;
    }

    @JsonProperty(value="rules")
    public void setRules(List<SegmentRule> rules) {
        this.rules = rules;
    }

    public SegmentRule withRules(List<SegmentRule> rules) {
        this.rules = rules;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public SegmentRule withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SegmentRule.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("conditions");
        sb.append('=');
        sb.append(this.conditions == null ? "<null>" : this.conditions);
        sb.append(',');
        sb.append("rules");
        sb.append('=');
        sb.append(this.rules == null ? "<null>" : this.rules);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.rules == null ? 0 : this.rules.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.conditions == null ? 0 : this.conditions.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SegmentRule)) {
            return false;
        }
        SegmentRule rhs = (SegmentRule)other;
        return (this.rules == rhs.rules || this.rules != null && this.rules.equals(rhs.rules)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.conditions == rhs.conditions || this.conditions != null && this.conditions.equals(rhs.conditions));
    }

    public static enum Type {
        ALL("ALL"),
        ANY("ANY"),
        NONE("NONE");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

