/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.offline;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flagsmith.MapperFactory;
import com.flagsmith.exceptions.FlagsmithClientError;
import com.flagsmith.interfaces.IOfflineHandler;
import com.flagsmith.models.environments.EnvironmentModel;
import java.io.File;
import java.io.IOException;

public class LocalFileHandler
implements IOfflineHandler {
    private EnvironmentModel environmentModel;
    private ObjectMapper objectMapper = MapperFactory.getMapper();

    public LocalFileHandler(String filePath) throws FlagsmithClientError {
        File file = new File(filePath);
        try {
            this.environmentModel = (EnvironmentModel)this.objectMapper.readValue(file, EnvironmentModel.class);
        }
        catch (IOException e) {
            throw new FlagsmithClientError("Unable to read environment from file " + filePath);
        }
    }

    @Override
    public EnvironmentModel getEnvironment() {
        return this.environmentModel;
    }
}

