/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.threads;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flagsmith.FlagsmithLogger;
import com.flagsmith.MapperFactory;
import com.flagsmith.config.Retry;
import com.flagsmith.exceptions.FlagsmithApiError;
import com.flagsmith.exceptions.FlagsmithRuntimeError;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import lombok.Generated;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class RequestProcessor {
    private ExecutorService executor = Executors.newFixedThreadPool(3);
    private OkHttpClient client;
    private FlagsmithLogger logger;
    private Retry retries = new Retry(3);

    public RequestProcessor(OkHttpClient client, FlagsmithLogger logger) {
        this(client, logger, new Retry(3));
    }

    public RequestProcessor(OkHttpClient client, FlagsmithLogger logger, Retry retries) {
        this.client = client;
        this.logger = logger;
        this.retries = retries;
    }

    public <T> Future<T> executeAsync(Request request, TypeReference<T> clazz, Boolean doThrow) {
        return this.executeAsync(request, clazz, doThrow, this.retries);
    }

    public Future<JsonNode> executeAsync(Request request, Boolean doThrow) {
        return this.executeAsync(request, new TypeReference<JsonNode>(){}, doThrow, this.retries);
    }

    public <T> Future<T> executeAsync(Request request, TypeReference<T> clazz, Boolean doThrow, Retry retries) {
        CompletableFuture completableFuture = new CompletableFuture();
        Retry localRetry = retries.toBuilder().build();
        this.executor.submit(() -> {
            try {
                Integer statusCode = null;
                do {
                    Call call = this.getClient().newCall(request);
                    localRetry.waitWithBackoff();
                    Boolean throwOrNot = localRetry.getAttempts() == localRetry.getTotal() ? doThrow : Boolean.FALSE;
                    try (Response response = call.execute();){
                        statusCode = response.code();
                        if (response.isSuccessful()) {
                            ObjectMapper mapper = MapperFactory.getMapper();
                            completableFuture.complete(mapper.readValue(response.body().string(), clazz));
                            break;
                        }
                        this.getLogger().httpError(request, response, (boolean)throwOrNot);
                    }
                    catch (IOException e) {
                        this.getLogger().httpError(request, e, (boolean)throwOrNot);
                    }
                    localRetry.retryAttempted();
                } while (localRetry.isRetry(statusCode).booleanValue());
            }
            catch (Exception e) {
                throw new FlagsmithRuntimeError();
            }
            finally {
                if (!completableFuture.isDone()) {
                    if (doThrow.booleanValue()) {
                        completableFuture.obtrudeException(new FlagsmithApiError());
                    } else {
                        completableFuture.complete(null);
                    }
                }
            }
        });
        return completableFuture;
    }

    public void close() {
        this.executor.shutdown();
    }

    @Generated
    public OkHttpClient getClient() {
        return this.client;
    }

    @Generated
    public FlagsmithLogger getLogger() {
        return this.logger;
    }
}

