/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.utils;

import com.flagsmith.models.SdkTraitModel;
import com.flagsmith.models.TraitConfig;
import com.flagsmith.models.TraitModel;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ModelUtils {
    public static List<TraitModel> getTraitModelsFromTraitMap(Map<String, Object> traits) {
        return ModelUtils.getTraitModelStreamFromTraitMap(traits, () -> new TraitModel()).map(Pair::getLeft).collect(Collectors.toList());
    }

    public static List<SdkTraitModel> getSdkTraitModelsFromTraitMap(Map<String, Object> traits) {
        return ModelUtils.getTraitModelStreamFromTraitMap(traits, () -> new SdkTraitModel()).map(row -> {
            SdkTraitModel sdkTraitModel = (SdkTraitModel)row.getLeft();
            TraitConfig traitConfig = (TraitConfig)row.getRight();
            sdkTraitModel.setIsTransient(traitConfig.getIsTransient());
            return sdkTraitModel;
        }).collect(Collectors.toList());
    }

    private static Stream<Map.Entry<String, TraitConfig>> getTraitConfigStreamFromTraitMap(Map<String, Object> traits) {
        return traits.entrySet().stream().map(row -> new AbstractMap.SimpleEntry<String, TraitConfig>((String)row.getKey(), TraitConfig.fromObject(row.getValue())));
    }

    private static <T extends TraitModel> Stream<Pair<T, TraitConfig>> getTraitModelStreamFromTraitMap(Map<String, Object> traits, Supplier<T> traitSupplier) {
        return ModelUtils.getTraitConfigStreamFromTraitMap(traits).map(row -> {
            TraitModel trait = (TraitModel)traitSupplier.get();
            TraitConfig traitConfig = (TraitConfig)row.getValue();
            trait.setTraitKey((String)row.getKey());
            trait.setTraitValue(traitConfig.getValue());
            return new ImmutablePair((Object)trait, (Object)traitConfig);
        });
    }
}

