/*
 * Decompiled with CFR 0.152.
 */
package com.fleetpin.graphql.aws.lambda;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.JwkProviderBuilder;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.RSAKeyProvider;
import com.fasterxml.jackson.databind.JsonNode;
import com.fleetpin.graphql.builder.SchemaBuilder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;

public class CognitoValidator {
    private JWTVerifier jwtVerifier;

    public CognitoValidator(String region, String userPoolsId) {
        AwsCognitoRSAKeyProvider keyProvider = new AwsCognitoRSAKeyProvider(region, userPoolsId);
        Algorithm algorithm = Algorithm.RSA256((RSAKeyProvider)keyProvider);
        this.jwtVerifier = JWT.require((Algorithm)algorithm).build();
    }

    public JsonNode verify(String token) {
        DecodedJWT verified = this.jwtVerifier.verify(token);
        try {
            return SchemaBuilder.MAPPER.readTree(Base64.getDecoder().decode(verified.getPayload()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class AwsCognitoRSAKeyProvider
    implements RSAKeyProvider {
        private final URL aws_kid_store_url;

        public AwsCognitoRSAKeyProvider(String aws_cognito_region, String aws_user_pools_id) {
            String url = String.format("https://cognito-idp.%s.amazonaws.com/%s/.well-known/jwks.json", aws_cognito_region, aws_user_pools_id);
            try {
                this.aws_kid_store_url = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(String.format("Invalid URL provided, URL=%s", url));
            }
        }

        public RSAPublicKey getPublicKeyById(String kid) {
            try {
                JwkProvider provider = new JwkProviderBuilder(this.aws_kid_store_url).build();
                Jwk jwk = provider.get(kid);
                return (RSAPublicKey)jwk.getPublicKey();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to get JWT kid=%s from aws_kid_store_url=%s", kid, this.aws_kid_store_url));
            }
        }

        public RSAPrivateKey getPrivateKey() {
            return null;
        }

        public String getPrivateKeyId() {
            return null;
        }
    }
}

