/*
 * Decompiled with CFR 0.152.
 */
package com.fleetpin.graphql.aws.lambda;

import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fleetpin.graphql.aws.lambda.InterceptExecutionStrategy;
import com.fleetpin.graphql.aws.lambda.admin.Admin;
import com.fleetpin.graphql.aws.lambda.admin.User;
import com.fleetpin.graphql.aws.lambda.subscription.SubscriptionResponseKeepAlive;
import com.fleetpin.graphql.database.manager.dynamo.DynamoDbManager;
import graphql.GraphQL;
import graphql.execution.ExecutionStrategy;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.apigatewaymanagementapi.ApiGatewayManagementApiAsyncClient;
import software.amazon.awssdk.services.apigatewaymanagementapi.ApiGatewayManagementApiAsyncClientBuilder;

public abstract class LambdaAdminSource<U extends User, E>
implements RequestHandler<E, Void> {
    private static final Logger logger = LoggerFactory.getLogger(LambdaAdminSource.class);
    private final Admin<U> admin;
    private final DynamoDbManager manager;
    private final ApiGatewayManagementApiAsyncClient gatewayApi;
    private final long sentMessageTimeout;

    public LambdaAdminSource(String subscriptionTable, String gatewayUri) throws Exception {
        GraphQL graph = this.buildGraphQL().subscriptionExecutionStrategy((ExecutionStrategy)new InterceptExecutionStrategy()).build();
        this.manager = this.builderManager();
        this.gatewayApi = (ApiGatewayManagementApiAsyncClient)((ApiGatewayManagementApiAsyncClientBuilder)ApiGatewayManagementApiAsyncClient.builder().endpointOverride(new URI(gatewayUri))).build();
        this.admin = new Admin.AdminBuilder().withGraph(graph).withSubscriptionTable(subscriptionTable).withManager(this.manager).withLastSeenTimeout(Long.parseLong(System.getenv("ENV_LAST_SEEN_TIMEOUT"))).build();
        this.sentMessageTimeout = Long.parseLong(System.getenv("ENV_SENT_MESSAGE_TIMEOUT"));
    }

    protected Admin<U> getAdmin() {
        return this.admin;
    }

    protected CompletableFuture<Void> pingConnection(String connectionId) {
        return ((CompletableFuture)this.gatewayApi.postToConnection(b -> b.overrideConfiguration(c -> ((AwsRequestOverrideConfiguration.Builder)c.apiCallTimeout(Duration.ofMillis(this.sentMessageTimeout))).apiCallAttemptTimeout(Duration.ofMillis(this.sentMessageTimeout))).connectionId(connectionId).data(SdkBytes.fromString((String)this.getPingMessage(), (Charset)StandardCharsets.UTF_8))).exceptionally(error -> null)).thenAccept(response -> {
            if (response == null) {
                return;
            }
            this.admin.verified(connectionId);
        });
    }

    private String getPingMessage() {
        try {
            return this.manager.getMapper().writeValueAsString((Object)new SubscriptionResponseKeepAlive());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract GraphQL.Builder buildGraphQL() throws Exception;

    protected abstract DynamoDbManager builderManager();
}

