/*
 * Decompiled with CFR 0.152.
 */
package com.fleetpin.graphql.aws.lambda;

import java.lang.invoke.LambdaMetafactory;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.function.Supplier;

public class LambdaCache<K, V> {
    private static final ConcurrentLinkedQueue<WeakReference<LambdaCache<?, ?>>> entries = new ConcurrentLinkedQueue();
    private final Duration writeTTL;
    private final Map<K, CacheWrapper<V>> map;
    private final Function<K, V> producuer;

    public LambdaCache(Duration writeTTL, Function<K, V> builder) {
        this.writeTTL = writeTTL;
        this.producuer = builder;
        this.map = new ConcurrentHashMap<K, CacheWrapper<V>>();
        entries.add(new WeakReference<LambdaCache>(this));
    }

    private CacheWrapper<V> build(K key) {
        V value = this.producuer.apply(key);
        return new CacheWrapper<V>(Instant.now(), value);
    }

    public V get(K key) {
        return this.map.computeIfAbsent(key, (Function<Object, CacheWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, build(K ), (Ljava/lang/Object;)Lcom/fleetpin/graphql/aws/lambda/LambdaCache$CacheWrapper;)((LambdaCache)this)).value;
    }

    public V get(K key, Supplier<V> consumer) {
        return this.map.computeIfAbsent(key, (Function<Object, CacheWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$get$0(java.util.function.Supplier java.lang.Object ), (Ljava/lang/Object;)Lcom/fleetpin/graphql/aws/lambda/LambdaCache$CacheWrapper;)(consumer)).value;
    }

    public static void evict() {
        Instant now = Instant.now();
        Iterator<WeakReference<LambdaCache<?, ?>>> it = entries.iterator();
        while (it.hasNext()) {
            LambdaCache v = (LambdaCache)it.next().get();
            if (v == null) {
                it.remove();
                continue;
            }
            Iterator vIt = v.map.values().iterator();
            while (vIt.hasNext()) {
                CacheWrapper value = vIt.next();
                if (!value.added.plus(v.writeTTL).isBefore(now)) continue;
                vIt.remove();
            }
        }
    }

    private static /* synthetic */ CacheWrapper lambda$get$0(Supplier consumer, Object __) {
        return new CacheWrapper(Instant.now(), consumer.get());
    }

    private static class CacheWrapper<V> {
        private final Instant added;
        private final V value;

        public CacheWrapper(Instant added, V value) {
            this.added = added;
            this.value = value;
        }
    }
}

