/*
 * Decompiled with CFR 0.152.
 */
package com.fleetpin.graphql.aws.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2ProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2ProxyResponseEvent;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fleetpin.graphql.aws.lambda.ContextGraphQL;
import com.fleetpin.graphql.aws.lambda.GraphQLQuery;
import com.fleetpin.graphql.aws.lambda.LambdaCache;
import com.fleetpin.graphql.builder.SchemaBuilder;
import graphql.ExecutionResult;
import graphql.GraphQL;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LambdaGraphQL<U, C extends ContextGraphQL>
implements RequestHandler<APIGatewayV2ProxyRequestEvent, APIGatewayV2ProxyResponseEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LambdaGraphQL.class);
    private final GraphQL build = this.buildGraphQL();
    private ObjectMapper mapper = this.builderObjectMapper();

    public APIGatewayV2ProxyResponseEvent handleRequest(APIGatewayV2ProxyRequestEvent input, Context context) {
        try {
            GraphQLQuery query = (GraphQLQuery)this.mapper.readValue(input.getBody(), GraphQLQuery.class);
            APIGatewayV2ProxyResponseEvent toReturn = new APIGatewayV2ProxyResponseEvent();
            CompletionStage result = ((CompletableFuture)this.validate((String)input.getHeaders().get("Authorization")).handle((user, userError) -> {
                if (userError != null) {
                    LOGGER.error("Failed to validate user", userError);
                    toReturn.setStatusCode(401);
                    return CompletableFuture.completedFuture(null);
                }
                Object graphContext = this.buildContext(user, query);
                CompletableFuture target = this.build.executeAsync(builder -> builder.query(query.getQuery()).operationName(query.getOperationName()).variables(query.getVariables()).context(graphContext));
                graphContext.start(target);
                return target;
            })).thenCompose(t -> t);
            toReturn.setStatusCode(200);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Access-Control-Allow-Origin", "*");
            headers.put("content-type", "application/json; charset=utf-8");
            toReturn.setHeaders(headers);
            ExecutionResult r = (ExecutionResult)((CompletableFuture)result).get();
            if (r != null) {
                ObjectNode tree = (ObjectNode)this.mapper.valueToTree((Object)r);
                if (tree.get("errors").isEmpty()) {
                    tree.remove("errors");
                }
                toReturn.setBody(this.mapper.writeValueAsString((Object)tree));
            } else {
                toReturn.setBody("");
            }
            APIGatewayV2ProxyResponseEvent aPIGatewayV2ProxyResponseEvent = toReturn;
            return aPIGatewayV2ProxyResponseEvent;
        }
        catch (Throwable e) {
            LOGGER.error("Failed to invoke graph", e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            LambdaCache.evict();
        }
    }

    protected ObjectMapper builderObjectMapper() {
        return SchemaBuilder.MAPPER;
    }

    protected abstract GraphQL buildGraphQL() throws Exception;

    protected abstract CompletableFuture<U> validate(String var1);

    protected abstract C buildContext(U var1, GraphQLQuery var2);
}

