/*
 * Decompiled with CFR 0.152.
 */
package com.fleetpin.graphql.aws.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2ProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2ProxyResponseEvent;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fleetpin.graphql.aws.lambda.GraphQLQuery;
import com.fleetpin.graphql.aws.lambda.InterceptExecutionStrategy;
import com.fleetpin.graphql.aws.lambda.LambdaCache;
import com.fleetpin.graphql.aws.lambda.admin.Admin;
import com.fleetpin.graphql.aws.lambda.admin.User;
import com.fleetpin.graphql.aws.lambda.subscription.SubscriptionConnectionInit;
import com.fleetpin.graphql.aws.lambda.subscription.SubscriptionMessage;
import com.fleetpin.graphql.aws.lambda.subscription.SubscriptionStart;
import com.fleetpin.graphql.aws.lambda.subscription.SubscriptionStop;
import com.fleetpin.graphql.aws.lambda.subscription.SubscriptionTerminate;
import com.fleetpin.graphql.database.manager.dynamo.DynamoDbManager;
import com.google.common.annotations.VisibleForTesting;
import graphql.GraphQL;
import graphql.execution.ExecutionStrategy;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.apigatewaymanagementapi.ApiGatewayManagementApiClient;
import software.amazon.awssdk.services.apigatewaymanagementapi.ApiGatewayManagementApiClientBuilder;

public abstract class LambdaSubscriptionControl<U extends User>
implements RequestHandler<APIGatewayV2ProxyRequestEvent, APIGatewayV2ProxyResponseEvent> {
    private final ApiGatewayManagementApiClient gatewayApi;
    private final DynamoDbManager manager;
    private final Admin<U> admin;
    private final Map<String, String> subscriptionNameMapping;

    public LambdaSubscriptionControl(String subscriptionTable, String gatewayUri) throws Exception {
        this(subscriptionTable, gatewayUri, Collections.emptyMap());
    }

    public LambdaSubscriptionControl(String subscriptionTable, String gatewayUri, Map<String, String> subscriptionNameMapping) throws Exception {
        this.prepare();
        this.manager = this.builderManager();
        GraphQL graph = this.buildGraphQL().subscriptionExecutionStrategy((ExecutionStrategy)new InterceptExecutionStrategy()).build();
        if (gatewayUri == null) {
            this.gatewayApi = null;
        } else {
            URI endpoint = new URI(gatewayUri);
            this.gatewayApi = (ApiGatewayManagementApiClient)((ApiGatewayManagementApiClientBuilder)ApiGatewayManagementApiClient.builder().endpointOverride(endpoint)).build();
        }
        this.admin = new Admin.AdminBuilder().withGraph(graph).withSubscriptionTable(subscriptionTable).withManager(this.manager).withLastSeenTimeout(Long.parseLong((String)(System.getenv("LAST_SEEN_TIMEOUT") != null ? System.getenv("LAST_SEEN_TIMEOUT") : "" + Duration.ofMinutes(15L).toMillis()))).build();
        this.subscriptionNameMapping = subscriptionNameMapping;
    }

    public APIGatewayV2ProxyResponseEvent handleRequest(APIGatewayV2ProxyRequestEvent input, Context context) {
        try {
            switch (input.getRequestContext().getEventType()) {
                case "CONNECT": {
                    break;
                }
                case "DISCONNECT": {
                    this.disconnect(input);
                    break;
                }
                case "MESSAGE": {
                    SubscriptionMessage graphQuery = (SubscriptionMessage)this.manager.getMapper().readValue(input.getBody(), SubscriptionMessage.class);
                    this.process(input.getRequestContext().getConnectionId(), graphQuery);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown event " + input.getRequestContext().getEventType());
                }
            }
            APIGatewayV2ProxyResponseEvent toReturn = new APIGatewayV2ProxyResponseEvent();
            toReturn.setStatusCode(200);
            APIGatewayV2ProxyResponseEvent aPIGatewayV2ProxyResponseEvent = toReturn;
            return aPIGatewayV2ProxyResponseEvent;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            LambdaCache.evict();
        }
    }

    private void disconnect(APIGatewayV2ProxyRequestEvent input) throws InterruptedException, ExecutionException {
        this.admin.disconnect(input.getRequestContext().getConnectionId());
    }

    @VisibleForTesting
    public void process(String connectionId, SubscriptionMessage<?> graphQuery) throws JsonProcessingException, InterruptedException, ExecutionException {
        if (graphQuery instanceof SubscriptionConnectionInit) {
            String authHeader = ((SubscriptionConnectionInit.ConnectionPayload)((SubscriptionConnectionInit)graphQuery).getPayload()).getAuthorization();
            CompletableFuture<U> userContext = this.validateUser(authHeader);
            SubscriptionMessage<Object> message = this.admin.connect(connectionId, (User)userContext.get());
            if (message != null) {
                this.sendMessage(connectionId, this.manager.getMapper().writeValueAsString(message));
            }
        } else if (graphQuery instanceof SubscriptionStart) {
            GraphQLQuery query = (GraphQLQuery)((SubscriptionStart)graphQuery).getPayload();
            String id = graphQuery.getId();
            SubscriptionMessage<?> message = this.admin.subscribe(connectionId, id, query, this::buildSubscriptionId);
            if (message != null) {
                this.sendMessage(connectionId, this.manager.getMapper().writeValueAsString(message));
            }
        } else if (graphQuery instanceof SubscriptionStop) {
            this.admin.unsubscribe(connectionId, graphQuery.getId());
        } else if (graphQuery instanceof SubscriptionTerminate) {
            this.admin.disconnect(connectionId);
        }
    }

    @VisibleForTesting
    protected void sendMessage(String connectionId, String message) {
        this.gatewayApi.postToConnection(b -> b.connectionId(connectionId).data(SdkBytes.fromString((String)message, (Charset)StandardCharsets.UTF_8)));
    }

    protected abstract void prepare() throws Exception;

    protected abstract GraphQL.Builder buildGraphQL() throws Exception;

    protected abstract DynamoDbManager builderManager();

    public abstract CompletableFuture<U> validateUser(String var1);

    public abstract String buildSubscriptionId(String var1, Map<String, Object> var2);
}

