/*
 * Decompiled with CFR 0.152.
 */
package com.fleetpin.graphql.aws.lambda;

import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fleetpin.graphql.aws.lambda.ContextGraphQL;
import com.fleetpin.graphql.aws.lambda.GraphQLQuery;
import com.fleetpin.graphql.aws.lambda.LambdaCache;
import com.fleetpin.graphql.aws.lambda.subscription.SubscriptionResponseData;
import com.fleetpin.graphql.database.manager.dynamo.DynamoDbManager;
import com.google.common.annotations.VisibleForTesting;
import graphql.ExecutionResult;
import graphql.GraphQL;
import io.reactivex.rxjava3.core.Flowable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.apigatewaymanagementapi.ApiGatewayManagementApiAsyncClient;
import software.amazon.awssdk.services.apigatewaymanagementapi.ApiGatewayManagementApiAsyncClientBuilder;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.GoneException;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.PostToConnectionResponse;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;

public abstract class LambdaSubscriptionSource<E, T>
implements RequestHandler<E, Void> {
    private final DynamoDbManager manager;
    private final ApiGatewayManagementApiAsyncClient gatewayApi;
    private final GraphQL graph;
    private final LambdaCache<String, CompletableFuture<GetItemResponse>> userCache;
    private final LambdaCache<String, CompletableFuture<QueryResponse>> organisationCache;
    private final String subscriptionTable;
    private final long sentMessageTimeout;

    public LambdaSubscriptionSource(String subscriptionId, String subscriptionTable, String apiUri, Duration userCacheTTL, Duration subscriptionCacheTTL) throws Exception {
        this.prepare();
        this.subscriptionTable = subscriptionTable;
        this.manager = this.builderManager();
        this.graph = this.buildGraphQL();
        if (apiUri == null) {
            this.gatewayApi = null;
        } else {
            URI endpoint = new URI(apiUri);
            this.gatewayApi = (ApiGatewayManagementApiAsyncClient)((ApiGatewayManagementApiAsyncClientBuilder)ApiGatewayManagementApiAsyncClient.builder().endpointOverride(endpoint)).build();
        }
        this.organisationCache = new LambdaCache<String, CompletableFuture>(subscriptionCacheTTL, lookupId -> {
            HashMap<String, AttributeValue> keyConditions = new HashMap<String, AttributeValue>();
            keyConditions.put(":subscription", (AttributeValue)AttributeValue.builder().s(subscriptionId + ":" + lookupId).build());
            return this.manager.getDynamoDbAsyncClient().query(t -> t.tableName(subscriptionTable).indexName("subscription").keyConditionExpression("subscription = :subscription").expressionAttributeValues(keyConditions));
        });
        this.userCache = new LambdaCache<String, CompletableFuture>(userCacheTTL, connectionId -> {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put("connectionId", (AttributeValue)AttributeValue.builder().s(connectionId).build());
            key.put("id", (AttributeValue)AttributeValue.builder().s("auth").build());
            return this.manager.getDynamoDbAsyncClient().getItem(t -> t.tableName(subscriptionTable).key(key));
        });
        this.sentMessageTimeout = Long.parseLong((String)(System.getenv("ENV_SENT_MESSAGE_TIMEOUT") != null ? System.getenv("ENV_SENT_MESSAGE_TIMEOUT") : "" + Duration.ofMinutes(2L).toMillis()));
    }

    protected abstract void prepare() throws Exception;

    protected abstract GraphQL buildGraphQL() throws Exception;

    protected abstract DynamoDbManager builderManager();

    public abstract CompletableFuture<ContextGraphQL> buildContext(Flowable<T> var1, String var2, AttributeValue var3, Map<String, Object> var4);

    public abstract String buildSubscriptionId(T var1);

    @VisibleForTesting
    protected CompletableFuture<?> process(T t) {
        return this.organisationCache.get(this.buildSubscriptionId(t)).thenCompose(items -> {
            ArrayList<CompletableFuture<Void>> parts = new ArrayList<CompletableFuture<Void>>();
            for (Map item : items.items()) {
                String connectionId = ((AttributeValue)item.get("connectionId")).s();
                String id = ((AttributeValue)item.get("id")).s();
                GraphQLQuery query = (GraphQLQuery)this.manager.convertTo((AttributeValue)item.get("query"), GraphQLQuery.class);
                parts.add(this.processUpdate(connectionId, id, query, t));
            }
            return CompletableFuture.allOf((CompletableFuture[])parts.toArray(CompletableFuture[]::new));
        });
    }

    private CompletableFuture<Void> processUpdate(String connectionId, String id, GraphQLQuery query, T t) {
        return this.userCache.get(connectionId).thenCompose(user -> {
            if (user.item() == null || user.item().isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            Flowable publisher = Flowable.just((Object)t);
            return this.buildContext(publisher, ((AttributeValue)user.item().get("user")).s(), (AttributeValue)user.item().get("aditional"), query.getVariables()).thenCompose(context -> {
                CompletableFuture toReturn = this.graph.executeAsync(builder -> builder.query(query.getQuery()).operationName(query.getOperationName()).variables(query.getVariables()).context(context));
                context.start(toReturn);
                return toReturn.thenCompose(r -> {
                    if (!r.getErrors().isEmpty()) {
                        try {
                            SubscriptionResponseData data = new SubscriptionResponseData(id, (ExecutionResult)r);
                            String sendResponse = this.manager.getMapper().writeValueAsString((Object)data);
                            return this.sendMessage(connectionId, sendResponse).thenAccept(__ -> {});
                        }
                        catch (JsonProcessingException e) {
                            throw new UncheckedIOException((IOException)((Object)e));
                        }
                    }
                    Publisher stream = (Publisher)r.getData();
                    CompletionStage<Void> requestSent = Flowable.fromPublisher((Publisher)stream).map(item -> {
                        SubscriptionResponseData data = new SubscriptionResponseData(id, (ExecutionResult)item);
                        try {
                            String sendResponse = this.manager.getMapper().writeValueAsString((Object)data);
                            return ((CompletableFuture)((CompletableFuture)this.sendMessage(connectionId, sendResponse).handle((response, error) -> {
                                if (error != null) {
                                    if (error instanceof GoneException || error.getCause() instanceof GoneException) {
                                        return this.deleteUser((GetItemResponse)user);
                                    }
                                    throw new RuntimeException((Throwable)error);
                                }
                                return CompletableFuture.completedFuture(null);
                            })).thenCompose(promise -> promise)).thenAccept(__ -> {});
                        }
                        catch (JsonProcessingException e) {
                            throw new UncheckedIOException((IOException)((Object)e));
                        }
                    }).singleElement().toCompletionStage(CompletableFuture.completedFuture(null)).thenCompose(f -> f).thenAccept(__ -> {});
                    context.start(requestSent);
                    return requestSent;
                });
            });
        });
    }

    private CompletableFuture<Void> deleteUser(GetItemResponse user) {
        HashMap<String, AttributeValue> keyConditions = new HashMap<String, AttributeValue>();
        keyConditions.put(":connectionId", (AttributeValue)user.item().get("connectionId"));
        return this.manager.getDynamoDbAsyncClient().query(t -> t.tableName(this.subscriptionTable).keyConditionExpression("connectionId = :connectionId").expressionAttributeValues(keyConditions)).thenCompose(items -> {
            CompletableFuture[] futures = (CompletableFuture[])items.items().stream().map(item -> {
                HashMap key = new HashMap(item);
                key.keySet().retainAll(Arrays.asList("connectionId", "id"));
                return this.manager.getDynamoDbAsyncClient().deleteItem(t -> t.tableName(this.subscriptionTable).key((Map)key));
            }).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(futures);
        });
    }

    @VisibleForTesting
    protected CompletableFuture<PostToConnectionResponse> sendMessage(String connectionId, String sendResponse) {
        return this.gatewayApi.postToConnection(b -> b.overrideConfiguration(c -> ((AwsRequestOverrideConfiguration.Builder)c.apiCallTimeout(Duration.ofMillis(this.sentMessageTimeout))).apiCallAttemptTimeout(Duration.ofMillis(this.sentMessageTimeout))).connectionId(connectionId).data(SdkBytes.fromString((String)sendResponse, (Charset)StandardCharsets.UTF_8)));
    }
}

