/*
 * Decompiled with CFR 0.152.
 */
package com.fleetpin.graphql.aws.lambda.admin;

import com.fleetpin.graphql.aws.lambda.GraphQLQuery;
import com.fleetpin.graphql.aws.lambda.admin.User;
import com.fleetpin.graphql.aws.lambda.subscription.SubscriptionMessage;
import com.fleetpin.graphql.aws.lambda.subscription.SubscriptionResponseAccept;
import com.fleetpin.graphql.aws.lambda.subscription.SubscriptionResponseConnectionError;
import com.fleetpin.graphql.aws.lambda.subscription.SubscriptionResponseError;
import com.fleetpin.graphql.database.manager.dynamo.DynamoDbManager;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;

public class Admin<U extends User> {
    private final GraphQL graph;
    private final String subscriptionTable;
    private final DynamoDbManager manager;
    private final long lastSeenTimeout;
    private final Map<String, String> subscriptionNameMapping;
    private final Time time;

    public Admin(GraphQL graph, String subscriptionTable, DynamoDbManager manager, long lastSeenTimeout, Map<String, String> subscriptionNameMapping, Time time) {
        this.graph = graph;
        this.subscriptionTable = subscriptionTable;
        this.manager = manager;
        this.lastSeenTimeout = lastSeenTimeout;
        this.subscriptionNameMapping = subscriptionNameMapping;
        this.time = time;
    }

    public SubscriptionMessage<Object> connect(String connectionId, U user) {
        try {
            if (user != null) {
                HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
                item.put("connectionId", (AttributeValue)AttributeValue.builder().s(connectionId).build());
                item.put("id", (AttributeValue)AttributeValue.builder().s("auth").build());
                item.put("user", (AttributeValue)AttributeValue.builder().s(user.getId()).build());
                AttributeValue additional = user.getExtraUserInfo();
                if (additional != null) {
                    item.put("aditional", additional);
                }
                item.put("ttl", (AttributeValue)AttributeValue.builder().n(Long.toString(this.time.currentTime().plus(7L, ChronoUnit.DAYS).toEpochMilli())).build());
                item.put("lastSeen", (AttributeValue)AttributeValue.builder().n(Long.toString(this.time.currentTime().toEpochMilli())).build());
                this.manager.getDynamoDbAsyncClient().putItem(t -> t.tableName(this.subscriptionTable).item(item)).get();
                return new SubscriptionResponseAccept();
            }
            return new SubscriptionResponseConnectionError("No token");
        }
        catch (Exception e) {
            return new SubscriptionResponseConnectionError(e.getMessage());
        }
    }

    public boolean isConnected(String connectionId) throws ExecutionException, InterruptedException {
        HashMap<String, AttributeValue> keyConditions = new HashMap<String, AttributeValue>();
        keyConditions.put(":connectionId", (AttributeValue)AttributeValue.builder().s(connectionId).build());
        QueryRequest request = (QueryRequest)QueryRequest.builder().tableName(this.subscriptionTable).keyConditionExpression("connectionId = :connectionId").expressionAttributeValues(keyConditions).build();
        QueryResponse response = (QueryResponse)this.manager.getDynamoDbAsyncClient().query(request).get();
        return !response.items().isEmpty();
    }

    public void disconnect(String connectionId) throws ExecutionException, InterruptedException {
        List<Map<String, AttributeValue>> items = this.getConnections(connectionId);
        for (Map<String, AttributeValue> item : items) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>(item);
            key.keySet().retainAll(Arrays.asList("connectionId", "id"));
            this.manager.getDynamoDbAsyncClient().deleteItem(t -> t.tableName(this.subscriptionTable).key((Map)key)).get();
        }
    }

    public SubscriptionMessage<?> subscribe(String connectionId, String queryId, GraphQLQuery query, SubscriptionIdBuilder idBuilder) {
        try {
            ExecutionResult result = this.graph.execute(builder -> builder.query(query.getQuery()).operationName(query.getOperationName()).variables(query.getVariables()));
            if (!result.getErrors().isEmpty()) {
                GraphQLError error = (GraphQLError)result.getErrors().get(0);
                return new SubscriptionResponseError(queryId, error);
            }
            String subscription = this.mapSubscriptionName((String)result.getData());
            HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
            item.put("connectionId", (AttributeValue)AttributeValue.builder().s(connectionId).build());
            item.put("id", (AttributeValue)AttributeValue.builder().s(queryId).build());
            item.put("subscription", (AttributeValue)AttributeValue.builder().s(subscription + ":" + idBuilder.build(subscription, query.getVariables())).build());
            item.put("query", this.manager.toAttributes((Object)query));
            item.put("ttl", (AttributeValue)AttributeValue.builder().n(Long.toString(this.time.currentTime().plus(7L, ChronoUnit.DAYS).toEpochMilli())).build());
            item.put("lastSeen", (AttributeValue)AttributeValue.builder().n(Long.toString(this.time.currentTime().toEpochMilli())).build());
            this.manager.getDynamoDbAsyncClient().putItem(t -> t.tableName(this.subscriptionTable).item(item)).get();
        }
        catch (Exception e) {
            GraphQLError error = GraphqlErrorBuilder.newError().message(e.getMessage(), new Object[0]).build();
            return new SubscriptionResponseError(queryId, error);
        }
        return null;
    }

    public boolean isSubscribed(String connectionId, String queryId) throws ExecutionException, InterruptedException {
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put("connectionId", (AttributeValue)AttributeValue.builder().s(connectionId).build());
        item.put("id", (AttributeValue)AttributeValue.builder().s(queryId).build());
        GetItemResponse result = (GetItemResponse)this.manager.getDynamoDbAsyncClient().getItem(t -> t.tableName(this.subscriptionTable).key(item)).get();
        return result.hasItem();
    }

    public void unsubscribe(String connectionId, String queryId) throws ExecutionException, InterruptedException {
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put("connectionId", (AttributeValue)AttributeValue.builder().s(connectionId).build());
        item.put("id", (AttributeValue)AttributeValue.builder().s(queryId).build());
        this.manager.getDynamoDbAsyncClient().deleteItem(t -> t.tableName(this.subscriptionTable).key(item)).get();
    }

    public List<String> verify() {
        ScanRequest request = (ScanRequest)ScanRequest.builder().tableName(this.subscriptionTable).projectionExpression("connectionId, lastSeen").build();
        try {
            return ((ScanResponse)this.manager.getDynamoDbAsyncClient().scan(request).get()).items().stream().map(item -> {
                if (this.verify((Map<String, AttributeValue>)item)) {
                    return item;
                }
                return null;
            }).filter(Objects::nonNull).map(item -> ((AttributeValue)item.get("connectionId")).s()).collect(Collectors.toList());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void verified(String connectionId) {
        try {
            long now = this.time.currentTime().toEpochMilli();
            HashMap<String, AttributeValueUpdate> updates = new HashMap<String, AttributeValueUpdate>();
            List<Map<String, AttributeValue>> connections = this.getConnections(connectionId);
            updates.put("lastSeen", (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.PUT).value((AttributeValue)AttributeValue.builder().n(String.valueOf(now)).build()).build());
            for (Map<String, AttributeValue> connection : connections) {
                String id = connection.get("id").s();
                HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
                key.put("connectionId", (AttributeValue)AttributeValue.builder().s(connectionId).build());
                key.put("id", (AttributeValue)AttributeValue.builder().s(id).build());
                UpdateItemRequest request = (UpdateItemRequest)UpdateItemRequest.builder().key(key).attributeUpdates(updates).tableName(this.subscriptionTable).build();
                this.manager.getDynamoDbAsyncClient().updateItem(request).get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Map<String, AttributeValue>> getConnections(String connectionId) throws InterruptedException, ExecutionException {
        HashMap<String, AttributeValue> keyConditions = new HashMap<String, AttributeValue>();
        keyConditions.put(":connectionId", (AttributeValue)AttributeValue.builder().s(connectionId).build());
        return ((QueryResponse)this.manager.getDynamoDbAsyncClient().query(t -> t.tableName(this.subscriptionTable).keyConditionExpression("connectionId = :connectionId").expressionAttributeValues(keyConditions)).get()).items();
    }

    private boolean verify(Map<String, AttributeValue> item) {
        long lastSeen = Long.parseLong(item.get("lastSeen").n());
        if (this.time.currentTime().toEpochMilli() - this.lastSeenTimeout < lastSeen) {
            return true;
        }
        try {
            this.disconnect(item.get("connectionId").s());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    private String mapSubscriptionName(String name) {
        return this.subscriptionNameMapping.getOrDefault(name, name);
    }

    public static interface Time {
        public Instant currentTime();
    }

    public static interface SubscriptionIdBuilder {
        public String build(String var1, Map<String, Object> var2);
    }

    public static class AdminBuilder<U extends User> {
        private GraphQL graph;
        private String subscriptionTable;
        private DynamoDbManager manager;
        private Long lastSeenTimeout;
        private Map<String, String> subscriptionNameMapping = Collections.emptyMap();
        private Time time = Instant::now;

        public AdminBuilder<U> withGraph(GraphQL graph) {
            this.graph = graph;
            return this;
        }

        public AdminBuilder<U> withSubscriptionTable(String subscriptionTable) {
            this.subscriptionTable = subscriptionTable;
            return this;
        }

        public AdminBuilder<U> withManager(DynamoDbManager manager) {
            this.manager = manager;
            return this;
        }

        public AdminBuilder<U> withLastSeenTimeout(long lastSeenTimeout) {
            this.lastSeenTimeout = lastSeenTimeout;
            return this;
        }

        public AdminBuilder<U> withSubscriptionNameMapping(Map<String, String> subscriptionNameMapping) {
            this.subscriptionNameMapping = subscriptionNameMapping;
            return this;
        }

        public AdminBuilder<U> withTime(Time time) {
            this.time = time;
            return this;
        }

        public Admin<U> build() {
            return new Admin(Objects.requireNonNull(this.graph), Objects.requireNonNull(this.subscriptionTable), Objects.requireNonNull(this.manager), Objects.requireNonNull(this.lastSeenTimeout), this.subscriptionNameMapping, this.time);
        }
    }
}

