/*
 * Decompiled with CFR 0.152.
 */
package com.fleetpin.graphql.aws.lambda.util;

import com.fleetpin.graphql.builder.annotations.GraphQLIgnore;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class InputMapper {
    public static void assign(Object existing, Object input) {
        try {
            Class<?> existingClass = existing.getClass();
            Class<?> inputClass = input.getClass();
            for (Field inputField : InputMapper.getFields(inputClass)) {
                Field existingField;
                inputField.setAccessible(true);
                Object obj = inputField.get(input);
                Class type = inputField.getType();
                Type generic = inputField.getGenericType();
                if (obj == null || (existingField = InputMapper.getField(existingClass, inputField.getName())) == null || Modifier.isStatic(inputField.getModifiers()) || Modifier.isStatic(existingField.getModifiers()) || Modifier.isFinal(inputField.getModifiers()) || Modifier.isFinal(existingField.getModifiers())) continue;
                if (obj instanceof Optional) {
                    obj = ((Optional)obj).orElse(null);
                    Type t = ((ParameterizedType)generic).getActualTypeArguments()[0];
                    if (t instanceof Class) {
                        type = (Class)t;
                    } else {
                        type = (Class)((ParameterizedType)t).getRawType();
                        generic = t;
                    }
                }
                existingField.setAccessible(true);
                if (obj instanceof Collection) {
                    ParameterizedType inputType;
                    Class inputInnerClass;
                    ParameterizedType existingType = (ParameterizedType)existingField.getGenericType();
                    Class existingInnerClass = (Class)existingType.getActualTypeArguments()[0];
                    if (existingInnerClass.isAssignableFrom(inputInnerClass = (Class)(inputType = (ParameterizedType)generic).getActualTypeArguments()[0])) {
                        existingField.set(existing, obj);
                        continue;
                    }
                    ArrayList toSet = new ArrayList();
                    for (Object o : (Collection)obj) {
                        Object build = existingInnerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        InputMapper.assign(build, o);
                        toSet.add(build);
                    }
                    existingField.set(existing, toSet);
                    continue;
                }
                if (existingField.getType().isAssignableFrom(type)) {
                    existingField.set(existing, obj);
                    continue;
                }
                Object existingObj = existingField.get(existing);
                if (existingObj == null) {
                    existingObj = existingField.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
                    existingField.set(existing, existingObj);
                }
                InputMapper.assign(existingObj, obj);
            }
            for (Method method : existingClass.getMethods()) {
                if (method.getDeclaringClass().equals(Object.class) || method.isAnnotationPresent(GraphQLIgnore.class) || Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 0 || method.getName().equals("getCreatedAt") || method.getName().equals("getUpdatedAt") || !method.getName().matches("(get|is)[A-Z].*")) continue;
                String name = method.getName().startsWith("get") ? method.getName().substring("get".length(), "get".length() + 1).toLowerCase() + method.getName().substring("get".length() + 1) : method.getName().substring("is".length(), "is".length() + 1).toLowerCase() + method.getName().substring("is".length() + 1);
                if (method.invoke(existing, new Object[0]) != null) continue;
                throw new RuntimeException("Missing required type " + name);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getField(Class existingClass, String name) {
        for (Field field : InputMapper.getFields(existingClass)) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    private static List<Field> getFields(Class<?> inputClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (inputClass != null) {
            fields.addAll(Arrays.asList(inputClass.getDeclaredFields()));
            inputClass = inputClass.getSuperclass();
        }
        return fields;
    }
}

