/*
 * Decompiled with CFR 0.152.
 */
package com.flutterwave.services;

import com.flutterwave.bean.BeneficiaryRequest;
import com.flutterwave.bean.ChargeTypes;
import com.flutterwave.bean.ListResponse;
import com.flutterwave.bean.Response;
import com.flutterwave.client.Utility;
import com.flutterwave.utility.Properties;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class Beneficiaries {
    private String ERROR = "Error processing request, please check logs";

    public Response runCreateBeneficiary(BeneficiaryRequest beneficiaryRequest) {
        return Optional.of(Utility.post(Properties.getProperty("BENEFICIARY_BASE"), beneficiaryRequest.toString(), ChargeTypes.BENEFICIARY, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public ListResponse runGetAllBeneficiaries(Optional<Integer> page) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        page.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("page", s.toString())));
        return Optional.of(Utility.get(Properties.getProperty("BENEFICIARY_BASE"), ChargeTypes.BENEFICIARY, nameValuePairs)).map(ListResponse::toListResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runGetBeneficiary(int id) {
        return Optional.of(Utility.get(Properties.getProperty("BENEFICIARY_BASE") + "/" + id, ChargeTypes.BENEFICIARY, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runDeleteBeneficiary(int id) {
        return Optional.of(Utility.delete(Properties.getProperty("BENEFICIARY_BASE") + "/" + id, ChargeTypes.BENEFICIARY, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }
}

