/*
 * Decompiled with CFR 0.152.
 */
package com.zink.fly.example;

import com.zink.fly.Fly;
import com.zink.fly.MultiFly;
import com.zink.fly.example.FlyEntry;
import com.zink.fly.kit.FlyFinder;
import java.util.ArrayList;
import java.util.Collection;

public class MultiOps {
    public static void main(String[] stringArray) {
        Fly fly = new FlyFinder().find();
        ArrayList<FlyEntry> arrayList = new ArrayList<FlyEntry>(1000);
        for (int i = 0; i < 1000; ++i) {
            FlyEntry flyEntry = new FlyEntry();
            flyEntry.name = "MultiFly";
            flyEntry.reference = new Integer(i);
            flyEntry.setPayloadOfSize(20);
            arrayList.add(flyEntry);
        }
        FlyEntry flyEntry = new FlyEntry();
        flyEntry.name = "MultiFly";
        flyEntry.reference = null;
        flyEntry.payload = null;
        System.out.println("Doing 1000 writes reads and takes");
        System.out.println("with single methods ...");
        long l = System.currentTimeMillis();
        MultiOps.writeReadAndTakeSingle(fly, flyEntry, arrayList);
        long l2 = System.currentTimeMillis();
        float f = (float)(l2 - l) / 1000.0f;
        System.out.println("Which took " + f + " seconds\n");
        System.out.println("Doing 1000 writes reads and takes");
        System.out.println("with multi methods ...");
        l = System.currentTimeMillis();
        MultiOps.writeReadAndTakeMulti(fly, flyEntry, arrayList);
        l2 = System.currentTimeMillis();
        f = (float)(l2 - l) / 1000.0f;
        System.out.println("Which took " + f + " seconds");
    }

    private static void writeReadAndTakeSingle(MultiFly multiFly, FlyEntry flyEntry, Collection<FlyEntry> collection) {
        for (FlyEntry flyEntry2 : collection) {
            multiFly.write(flyEntry2, 100000L);
        }
        for (FlyEntry flyEntry2 : collection) {
            multiFly.read(flyEntry, 0L);
        }
        for (FlyEntry flyEntry2 : collection) {
            multiFly.take(flyEntry, 0L);
        }
    }

    private static void writeReadAndTakeMulti(MultiFly multiFly, FlyEntry flyEntry, Collection<FlyEntry> collection) {
        multiFly.writeMany(collection, 100000L);
        Collection<FlyEntry> collection2 = multiFly.readMany(flyEntry, collection.size());
        Collection<FlyEntry> collection3 = multiFly.takeMany(flyEntry, collection.size());
    }
}

