/*
 * Decompiled with CFR 0.152.
 */
package com.zink.fly.example;

import com.zink.fly.Fly;
import com.zink.fly.NotiFly;
import com.zink.fly.example.CallbackHandler;
import com.zink.fly.example.FlyEntry;
import com.zink.fly.kit.FlyFinder;

class Notification {
    Notification() {
    }

    public static void main(String[] stringArray) throws InterruptedException {
        FlyFinder flyFinder = new FlyFinder();
        Fly fly = flyFinder.find();
        System.out.println("Setting up notify handler");
        Notification.setUpWriteNotify(fly);
        Notification.writeNonMatchingEntry(fly);
        Notification.writeMatchingEntry(fly);
        Thread.yield();
        System.out.println("Waiting for Notify handler's lease to expire");
        Thread.sleep(1100L);
        Notification.writeMatchingEntry(fly);
        System.out.println("End.");
    }

    private static void setUpWriteNotify(NotiFly notiFly) {
        CallbackHandler callbackHandler = new CallbackHandler();
        FlyEntry flyEntry = new FlyEntry();
        flyEntry.name = "Example NotiFly Entry";
        flyEntry.reference = null;
        flyEntry.payload = null;
        notiFly.notifyWrite(flyEntry, callbackHandler, 1000L);
    }

    private static void writeNonMatchingEntry(NotiFly notiFly) {
        FlyEntry flyEntry = new FlyEntry();
        flyEntry.name = "Not a matching entry";
        flyEntry.reference = new Integer(7);
        flyEntry.payload = new String("Seven");
        notiFly.write(flyEntry, 1000L);
    }

    private static void writeMatchingEntry(NotiFly notiFly) {
        FlyEntry flyEntry = new FlyEntry();
        flyEntry.name = "Example NotiFly Entry";
        flyEntry.reference = new Integer(11);
        flyEntry.payload = new String("Eleven");
        notiFly.write(flyEntry, 1000L);
    }
}

