/*
 * Decompiled with CFR 0.152.
 */
package com.zink.fly.kit;

import com.zink.fly.kit.FlyDiscoveredHandler;
import com.zink.fly.kit.FlyLostHandler;
import com.zink.fly.kit.FlyRepHandler;
import com.zink.fly.kit.FlyServerRep;
import com.zink.fly.kit.MulticastRequestor;
import com.zink.fly.kit.MulticastResponseListener;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FlyCache
implements FlyRepHandler {
    private List<FlyDiscoveredHandler> discoveredHandlers = new ArrayList<FlyDiscoveredHandler>(2);
    private List<FlyLostHandler> lostHandlers = new ArrayList<FlyLostHandler>(2);
    MulticastRequestor mcr = new MulticastRequestor();
    ExecutorService exec = null;
    MulticastResponseListener listener = null;
    private HashMap<InetAddress, FlyServerRep> reps = new LinkedHashMap<InetAddress, FlyServerRep>();

    public FlyCache() {
        this.start();
    }

    public Collection<FlyServerRep> getAllReps() {
        return new ArrayList<FlyServerRep>(this.reps.values());
    }

    public Collection<FlyServerRep> getMatchingReps(String[] stringArray) {
        ArrayList<FlyServerRep> arrayList = new ArrayList<FlyServerRep>();
        for (FlyServerRep flyServerRep : this.reps.values()) {
            if (!flyServerRep.tagsMatch(stringArray)) continue;
            arrayList.add(flyServerRep);
        }
        return arrayList;
    }

    public void registerDiscoveredHandler(FlyDiscoveredHandler flyDiscoveredHandler) {
        this.discoveredHandlers.add(flyDiscoveredHandler);
    }

    public void removeDiscoveredHandler(FlyDiscoveredHandler flyDiscoveredHandler) {
        this.discoveredHandlers.remove(flyDiscoveredHandler);
    }

    public void registerLostHandler(FlyLostHandler flyLostHandler) {
        this.lostHandlers.add(flyLostHandler);
    }

    public void removeLostHandler(FlyLostHandler flyLostHandler) {
        this.lostHandlers.remove(flyLostHandler);
    }

    @Override
    public void flyRepReply(FlyServerRep flyServerRep) {
        this.reps.put(flyServerRep.getFlyAddr(), flyServerRep);
    }

    public void issueRequest() {
        this.mcr.sendRequest();
    }

    public void start() {
        if (this.exec == null) {
            this.exec = Executors.newSingleThreadExecutor();
            this.listener = new MulticastResponseListener(this);
            this.exec.submit(this.listener);
        }
        this.issueRequest();
    }

    public void terminate() {
        this.listener.close();
        this.exec.shutdownNow();
        this.exec = null;
    }
}

