/*
 * Decompiled with CFR 0.152.
 */
package com.zink.fly.kit;

import com.zink.fly.FlyAccessException;
import com.zink.fly.kit.FlyRepHandler;
import com.zink.fly.kit.FlyServerRep;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;

public class MulticastResponseListener
implements Callable {
    private static final byte[] bytesAddress = new byte[]{-24, 43, 96, -24};
    private static final int MAX_BUFFER_SIZE = 512;
    private static final int port = 4397;
    private InetAddress multicastAddr = null;
    private FlyRepHandler repHandler = null;
    private MulticastSocket multicastSocket = null;

    public MulticastResponseListener(FlyRepHandler flyRepHandler) {
        try {
            this.repHandler = flyRepHandler;
            this.multicastAddr = InetAddress.getByAddress(bytesAddress);
        }
        catch (UnknownHostException unknownHostException) {
            new FlyAccessException(unknownHostException);
        }
    }

    public Object call() throws Exception {
        try {
            this.multicastSocket = new MulticastSocket(4397);
            this.multicastSocket.setReuseAddress(true);
            this.multicastSocket.joinGroup(this.multicastAddr);
            while (!Thread.currentThread().isInterrupted()) {
                byte[] byArray = new byte[512];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                this.multicastSocket.receive(datagramPacket);
                String string = new String(datagramPacket.getData(), 0, datagramPacket.getLength());
                FlyServerRep flyServerRep = new FlyServerRep(datagramPacket.getAddress(), string.split(" "));
                this.repHandler.flyRepReply(flyServerRep);
            }
            this.multicastSocket.leaveGroup(this.multicastAddr);
            this.multicastSocket.close();
        }
        catch (IOException iOException) {
            throw new FlyAccessException(iOException);
        }
        return null;
    }

    public void close() {
        try {
            this.multicastSocket.leaveGroup(this.multicastAddr);
        }
        catch (IOException iOException) {
            throw new FlyAccessException(iOException);
        }
        finally {
            this.multicastSocket.close();
        }
    }
}

