/*
 * Decompiled with CFR 0.152.
 */
package com.fundebug;

import com.fundebug.Event;

class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler oldHandler;
    private static Event event = null;

    ExceptionHandler(Thread.UncaughtExceptionHandler oldHandler) {
        this.oldHandler = oldHandler;
    }

    static void enableFundebugHandler(Event e) {
        Thread.UncaughtExceptionHandler handler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler(handler));
        event = e;
    }

    static void disableFundebugHandler() {
        Thread.UncaughtExceptionHandler handler = Thread.getDefaultUncaughtExceptionHandler();
        if (handler instanceof ExceptionHandler) {
            ExceptionHandler ehandler = (ExceptionHandler)handler;
            Thread.setDefaultUncaughtExceptionHandler(ehandler.oldHandler);
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        event.notifyError(t, e);
        if (this.oldHandler != null) {
            this.oldHandler.uncaughtException(t, e);
        } else {
            System.err.printf("Exception in thread \"%s\" ", t.getName());
            e.printStackTrace(System.err);
        }
    }
}

