/*
 * Decompiled with CFR 0.152.
 */
package com.fundebug;

import com.fundebug.JsonSerializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Serializer {
    private boolean prettyPrint;

    public Serializer() {
        this.prettyPrint = false;
    }

    public Serializer(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String serialize(JsonSerializable event) {
        StringBuilder builder = new StringBuilder();
        this.serializeValue(builder, event, 0);
        return builder.toString();
    }

    private void serializeValue(StringBuilder builder, Object value, int level) {
        if (value == null) {
            Serializer.serializeNull(builder);
        } else if (value instanceof Boolean) {
            Serializer.serializeBoolean(builder, (Boolean)value);
        } else if (value instanceof Number) {
            Serializer.serializeNumber(builder, (Number)value);
        } else if (value instanceof String) {
            Serializer.serializeString(builder, (String)value);
        } else if (value instanceof JsonSerializable) {
            this.serializeValue(builder, ((JsonSerializable)value).asJson(), level);
        } else if (value instanceof Map) {
            Map<String, Object> obj = Serializer.asMap((Map)value);
            this.serializeObject(obj, builder, level);
        } else if (value instanceof Collection) {
            this.serializeArray(builder, ((Collection)value).toArray(), level);
        } else if (value instanceof Object[]) {
            this.serializeArray(builder, (Object[])value, level);
        }
    }

    private static void serializeNumber(StringBuilder builder, Number value) {
        builder.append(value);
    }

    private static void serializeBoolean(StringBuilder builder, Boolean value) {
        builder.append(value != false ? "true" : "false");
    }

    private static void serializeNull(StringBuilder builder) {
        builder.append("null");
    }

    private void serializeArray(StringBuilder builder, Object[] array, int level) {
        builder.append('[');
        String comma = "";
        for (Object obj : array) {
            builder.append(comma);
            comma = ",";
            if (this.prettyPrint) {
                builder.append("\n");
                Serializer.indent(builder, level);
            }
            this.serializeValue(builder, obj, level + 1);
        }
        builder.append(']');
    }

    private static void serializeString(StringBuilder builder, String str) {
        builder.append('\"');
        builder.append(str.replace("\"", "\\\""));
        builder.append('\"');
    }

    private static void indent(StringBuilder builder, int i) {
        for (int x = 0; x <= i; ++x) {
            builder.append("  ");
        }
    }

    private static Map<String, Object> asMap(Map value) {
        try {
            Map obj = value;
            return obj;
        }
        catch (ClassCastException e) {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
            Iterator iterator = value.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry thisOne = o = iterator.next();
                Object key = thisOne.getKey();
                Object val = thisOne.getValue();
                obj.put(key.toString(), val);
            }
            return obj;
        }
    }

    private void serializeObject(Map<String, Object> content, StringBuilder builder, int level) {
        builder.append('{');
        String comma = "";
        for (Map.Entry<String, Object> entry : content.entrySet()) {
            builder.append(comma);
            comma = ",";
            if (this.prettyPrint) {
                builder.append("\n");
                Serializer.indent(builder, level);
            }
            Serializer.serializeString(builder, entry.getKey());
            builder.append(':');
            if (this.prettyPrint) {
                builder.append(" ");
            }
            this.serializeValue(builder, entry.getValue(), level + 1);
        }
        if (this.prettyPrint) {
            builder.append("\n");
        }
        builder.append('}');
    }
}

