/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;

public class FileFilterUtils {
    public static File[] filter(IOFileFilter filter, File ... files) {
        if (filter == null) {
            throw new IllegalArgumentException("file filter is null");
        }
        if (files == null) {
            return new File[0];
        }
        ArrayList<File> acceptedFiles = new ArrayList<File>();
        for (File file : files) {
            if (file == null) {
                throw new IllegalArgumentException("file array contains null");
            }
            if (!filter.accept(file)) continue;
            acceptedFiles.add(file);
        }
        return acceptedFiles.toArray(new File[acceptedFiles.size()]);
    }

    public static File[] filter(IOFileFilter filter, Iterable<File> files) {
        List<File> acceptedFiles = FileFilterUtils.filterList(filter, files);
        return acceptedFiles.toArray(new File[acceptedFiles.size()]);
    }

    public static List<File> filterList(IOFileFilter filter, Iterable<File> files) {
        return FileFilterUtils.filter(filter, files, new ArrayList());
    }

    public static List<File> filterList(IOFileFilter filter, File ... files) {
        File[] acceptedFiles = FileFilterUtils.filter(filter, files);
        return Arrays.asList(acceptedFiles);
    }

    public static Set<File> filterSet(IOFileFilter filter, File ... files) {
        File[] acceptedFiles = FileFilterUtils.filter(filter, files);
        return new HashSet<File>(Arrays.asList(acceptedFiles));
    }

    public static Set<File> filterSet(IOFileFilter filter, Iterable<File> files) {
        return FileFilterUtils.filter(filter, files, new HashSet());
    }

    private static <T extends Collection<File>> T filter(IOFileFilter filter, Iterable<File> files, T acceptedFiles) {
        if (filter == null) {
            throw new IllegalArgumentException("file filter is null");
        }
        if (files != null) {
            for (File file : files) {
                if (file == null) {
                    throw new IllegalArgumentException("file collection contains null");
                }
                if (!filter.accept(file)) continue;
                acceptedFiles.add((File)file);
            }
        }
        return acceptedFiles;
    }

    public static IOFileFilter nameFileFilter(String name) {
        return new NameFileFilter(name);
    }

    public static IOFileFilter nameFileFilter(String name, IOCase caseSensitivity) {
        return new NameFileFilter(name, caseSensitivity);
    }

    public static IOFileFilter directoryFileFilter() {
        return DirectoryFileFilter.DIRECTORY;
    }

    public static IOFileFilter fileFileFilter() {
        return FileFileFilter.FILE;
    }

    public static List<IOFileFilter> toList(IOFileFilter ... filters) {
        if (filters == null) {
            throw new IllegalArgumentException("The filters must not be null");
        }
        ArrayList<IOFileFilter> list = new ArrayList<IOFileFilter>(filters.length);
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] == null) {
                throw new IllegalArgumentException("The filter[" + i + "] is null");
            }
            list.add(filters[i]);
        }
        return list;
    }
}

