/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.core.asset;

import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.program.Program;
import com.github.DNAProject.core.program.ProgramInfo;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import com.github.DNAProject.io.Serializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class Sig
implements Serializable {
    public byte[][] pubKeys = null;
    public int M;
    public byte[][] sigData;

    @Override
    public void deserialize(BinaryReader reader) throws IOException {
        byte[] invocationScript = reader.readVarBytes();
        byte[] verificationScript = reader.readVarBytes();
        this.sigData = Program.getParamInfo(invocationScript);
        ProgramInfo info = Program.getProgramInfo(verificationScript);
        this.pubKeys = info.publicKey;
        this.M = info.m;
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.writeVarBytes(Program.ProgramFromParams(this.sigData));
        try {
            if (this.pubKeys.length == 1) {
                writer.writeVarBytes(Program.ProgramFromPubKey(this.pubKeys[0]));
            } else if (this.pubKeys.length > 1) {
                writer.writeVarBytes(Program.ProgramFromMultiPubKey(this.M, this.pubKeys));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object json() {
        HashMap<String, java.io.Serializable> json = new HashMap<String, java.io.Serializable>();
        json.put("M", Integer.valueOf(this.M));
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.pubKeys.length; ++i) {
            list.add(Helper.toHexString(this.pubKeys[i]));
        }
        ArrayList<String> list2 = new ArrayList<String>();
        for (int i = 0; i < this.sigData.length; ++i) {
            list2.add(Helper.toHexString(this.sigData[i]));
        }
        json.put("PubKeys", list);
        json.put("SigData", list2);
        return json;
    }
}

