/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.core.asset;

import com.github.DNAProject.common.Address;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import com.github.DNAProject.io.Serializable;
import java.io.IOException;
import java.util.HashMap;

public class TransferFrom
implements Serializable {
    public Address sender;
    public Address from;
    public Address to;
    public long value;

    public TransferFrom(Address sender, Address from, Address to, long amount) {
        this.sender = sender;
        this.from = from;
        this.to = to;
        this.value = amount;
    }

    @Override
    public void deserialize(BinaryReader reader) throws IOException {
        try {
            this.sender = reader.readSerializable(Address.class);
            this.from = reader.readSerializable(Address.class);
            this.to = reader.readSerializable(Address.class);
            this.value = reader.readVarInt();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.writeSerializable(this.sender);
        writer.writeSerializable(this.from);
        writer.writeSerializable(this.to);
        writer.writeVarInt(this.value);
    }

    public Object json() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("sender", this.sender.toHexString());
        json.put("from", this.from.toHexString());
        json.put("to", this.to.toHexString());
        json.put("value", this.value);
        return json;
    }
}

