/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.core.payload;

import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.core.transaction.TransactionType;
import com.github.DNAProject.crypto.ECC;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.math.ec.ECPoint;

public class Vote
extends Transaction {
    public ECPoint[] pubKeys;
    public Address account;

    public Vote() {
        super(TransactionType.Vote);
    }

    @Override
    protected void deserializeExclusiveData(BinaryReader reader) throws IOException {
        try {
            int len = reader.readInt();
            this.pubKeys = new ECPoint[len];
            for (int i = 0; i < len; ++i) {
                this.pubKeys[i] = ECC.secp256r1.getCurve().createPoint(new BigInteger(1, reader.readVarBytes()), new BigInteger(1, reader.readVarBytes()));
            }
            this.account = reader.readSerializable(Address.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Address[] getAddressU160ForVerifying() {
        return null;
    }

    @Override
    protected void serializeExclusiveData(BinaryWriter writer) throws IOException {
        writer.writeInt(this.pubKeys.length);
        for (ECPoint pubkey : this.pubKeys) {
            writer.writeVarBytes(Helper.removePrevZero(pubkey.getXCoord().toBigInteger().toByteArray()));
            writer.writeVarBytes(Helper.removePrevZero(pubkey.getYCoord().toBigInteger().toByteArray()));
        }
        writer.writeSerializable(this.account);
    }
}

