/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.core.scripts;

import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.sdk.exception.SDKRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;

public class WasmScriptBuilder
implements AutoCloseable {
    private ByteArrayOutputStream ms = new ByteArrayOutputStream();
    private static BigInteger maxInt128 = new BigInteger("2").pow(127).subtract(BigInteger.ONE);
    private static BigInteger minInt128 = new BigInteger("2").pow(127).negate();

    WasmScriptBuilder() {
    }

    @Override
    public void close() {
        try {
            this.ms.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    void reset() {
        this.ms.reset();
    }

    public static byte[] createWasmInvokeCode(String contractHash, String method, List<Object> params) {
        try {
            WasmScriptBuilder headBuilder = new WasmScriptBuilder();
            headBuilder.pushWithoutLen(Helper.reverse(Helper.hexToBytes(contractHash)));
            return Helper.addBytes(headBuilder.toByteArray(), WasmScriptBuilder.createWasmCodeParamsScript(method, params));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SDKRuntimeException("Create wasm invoke code failed");
        }
    }

    private static byte[] createWasmCodeParamsScript(String method, List<Object> list) {
        WasmScriptBuilder builder = new WasmScriptBuilder();
        builder.push(method);
        list.forEach(builder::pushVmParam);
        return builder.packAsArray();
    }

    private void pushVmParam(Object val) {
        if (val instanceof byte[]) {
            this.push((byte[])val);
        } else if (val instanceof Address) {
            this.push((Address)val);
        } else if (val instanceof String) {
            this.push((String)val);
        } else if (val instanceof Boolean) {
            this.push((Boolean)val);
        } else if (val instanceof Integer) {
            this.push((Integer)val);
        } else if (val instanceof Long) {
            this.push((Long)val);
        } else if (val instanceof List) {
            List listVal = (List)val;
            this.pushVarUInt(Long.valueOf(listVal.size()));
            for (Object param : listVal) {
                this.pushVmParam(param);
            }
        } else {
            throw new SDKRuntimeException("Invalid data");
        }
    }

    public byte[] toByteArray() {
        return this.ms.toByteArray();
    }

    public String toHexString() {
        return Helper.toHexString(this.toByteArray());
    }

    private byte[] packAsArray() {
        WasmScriptBuilder finalBuilder = new WasmScriptBuilder();
        finalBuilder.push(this.toByteArray());
        return finalBuilder.toByteArray();
    }

    void push(Boolean val) {
        if (val.booleanValue()) {
            this.ms.write(1);
        } else {
            this.ms.write(0);
        }
    }

    void pushWithoutLen(byte[] data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.ms.write(data, 0, data.length);
    }

    void push(byte[] data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.pushVarUInt(Long.valueOf(data.length));
        this.ms.write(data, 0, data.length);
    }

    void push(Address val) {
        byte[] byteVal = val.toArray();
        this.ms.write(byteVal, 0, byteVal.length);
    }

    void push(String data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.push(data.getBytes());
    }

    void push(Integer data) {
        if (data == null) {
            throw new SDKRuntimeException("NULL Pointer exception");
        }
        this.push(BigInteger.valueOf(data.intValue()));
    }

    void push(Long data) {
        if (data == null) {
            throw new SDKRuntimeException("NULL Pointer exception");
        }
        this.push(BigInteger.valueOf(data));
    }

    void push(BigInteger data) {
        int int128Length;
        if (data == null) {
            throw new SDKRuntimeException("NULL Pointer exception");
        }
        if (data.compareTo(minInt128) < 0 || data.compareTo(maxInt128) > 0) {
            throw new SDKRuntimeException("Out of range");
        }
        byte[] bytesData = Helper.reverse(data.toByteArray());
        if (bytesData.length > (int128Length = 16)) {
            throw new SDKRuntimeException("Data in bytes should be less equal then 16");
        }
        byte[] finalResult = new byte[int128Length];
        if (data.compareTo(BigInteger.ZERO) < 0) {
            Arrays.fill(finalResult, (byte)-1);
        }
        System.arraycopy(bytesData, 0, finalResult, 0, bytesData.length);
        this.ms.write(finalResult, 0, finalResult.length);
    }

    void pushVarUInt(Long data) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (data < 0L) {
            throw new RuntimeException();
        }
        if (data < 253L) {
            byte[] bytes = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(data).array();
            this.ms.write(bytes, 0, 1);
        } else if (data <= 65535L) {
            byte[] bytes = Helper.addBytes(new byte[]{-3}, ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(data).array());
            this.ms.write(bytes, 0, 3);
        } else if (data <= 0xFFFFFFFFL) {
            byte[] bytes = Helper.addBytes(new byte[]{-2}, ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(data).array());
            this.ms.write(bytes, 0, 5);
        } else {
            byte[] bytes = Helper.addBytes(new byte[]{-1}, ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(data).array());
            this.ms.write(bytes, 0, 9);
        }
    }
}

