/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.core.transaction;

import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.transaction.AttributeUsage;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import com.github.DNAProject.io.Serializable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class Attribute
implements Serializable {
    public AttributeUsage usage;
    public byte[] data;
    public int size;

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.writeByte(this.usage.value());
        if (this.usage != AttributeUsage.Script && this.usage != AttributeUsage.DescriptionUrl && this.usage != AttributeUsage.Description && this.usage != AttributeUsage.Nonce) {
            throw new IOException();
        }
        writer.writeVarBytes(this.data);
    }

    @Override
    public void deserialize(BinaryReader reader) throws IOException {
        this.usage = AttributeUsage.valueOf(reader.readByte());
        if (this.usage != AttributeUsage.Script && this.usage != AttributeUsage.DescriptionUrl && this.usage != AttributeUsage.Description && this.usage != AttributeUsage.Nonce) {
            throw new IOException();
        }
        this.data = reader.readVarBytes(255);
    }

    public Object json() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("usage", this.usage.value());
        json.put("data", Helper.toHexString(this.data));
        return json;
    }

    public String toString() {
        return "TransactionAttribute [usage=" + (Object)((Object)this.usage) + ", data=" + Arrays.toString(this.data) + "]";
    }
}

