/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.crypto;

import com.github.DNAProject.common.UInt256;
import com.github.DNAProject.crypto.Digest;
import java.util.Arrays;

public class MerkleTree {
    public static UInt256 computeRoot(UInt256[] hashes) {
        if (hashes.length == 0) {
            throw new IllegalArgumentException();
        }
        if (hashes.length == 1) {
            return hashes[0];
        }
        return new UInt256(MerkleTree.computeRoot((byte[][])Arrays.stream(hashes).map(p -> p.toArray()).toArray(x$0 -> new byte[x$0][])));
    }

    private static byte[] computeRoot(byte[][] hashes) {
        if (((byte[][])hashes).length == 0) {
            throw new IllegalArgumentException();
        }
        if (((byte[][])hashes).length == 1) {
            return hashes[0];
        }
        if (((byte[][])hashes).length % 2 == 1) {
            byte[][] temp = new byte[((byte[][])hashes).length + 1][];
            System.arraycopy(hashes, 0, temp, 0, ((byte[][])hashes).length);
            temp[temp.length - 1] = hashes[((byte[][])hashes).length - 1];
            hashes = temp;
        }
        byte[][] hashes_new = new byte[((byte[][])hashes).length / 2][];
        for (int i = 0; i < hashes_new.length; ++i) {
            byte[] buffer = new byte[hashes[i * 2].length + hashes[i * 2 + 1].length];
            System.arraycopy(hashes[i * 2], 0, buffer, 0, hashes[i * 2].length);
            System.arraycopy(hashes[i * 2 + 1], 0, buffer, hashes[i * 2].length, hashes[i * 2 + 1].length);
            hashes_new[i] = Digest.hash256(buffer);
        }
        return MerkleTree.computeRoot(hashes_new);
    }
}

