/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.crypto.bip32;

import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.crypto.bip32.Bitcoin;
import com.github.DNAProject.crypto.bip32.ByteArrayReader;
import com.github.DNAProject.crypto.bip32.Deserializer;
import com.github.DNAProject.crypto.bip32.HdKey;
import com.github.DNAProject.crypto.bip32.HdPublicKey;
import com.github.DNAProject.crypto.bip32.Network;
import com.github.DNAProject.sdk.exception.SDKException;
import io.github.novacrypto.base58.Base58;
import java.util.Arrays;

final class HdPublicKeyDeserializer
implements Deserializer<HdPublicKey> {
    static final HdPublicKeyDeserializer DEFAULT = new HdPublicKeyDeserializer(Bitcoin.MAIN_NET);
    private final Network network;

    HdPublicKeyDeserializer(Network network) {
        this.network = network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HdPublicKey deserialize(CharSequence extendedBase58Key) throws SDKException {
        byte[] extendedKeyData = Base58.base58Decode((CharSequence)extendedBase58Key);
        try {
            HdPublicKey hdPublicKey = this.deserialize(extendedKeyData);
            return hdPublicKey;
        }
        finally {
            Arrays.fill(extendedKeyData, (byte)0);
        }
    }

    @Override
    public HdPublicKey deserialize(byte[] extendedKeyData) throws SDKException {
        HdKey.confirmHdKeyChecksum(extendedKeyData);
        ByteArrayReader reader = new ByteArrayReader(extendedKeyData);
        int version = reader.readSer32();
        if (version != Bitcoin.MAIN_NET.getPublicVersion()) {
            throw new SDKException(ErrorCode.OtherError(String.format("Can't find network that matches private version 0x%x", version)));
        }
        return new HdPublicKey(new HdKey.Builder().network(Bitcoin.MAIN_NET).depth(reader.read()).parentFingerprint(reader.readSer32()).childNumber(reader.readSer32()).chainCode(reader.readRange(32)).key(reader.readRange(33)).neutered(true).build());
    }
}

