/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.dnaid;

import com.github.DNAProject.crypto.SignatureScheme;
import com.github.DNAProject.dnaid.ALG;

public enum PubKeyType {
    EcdsaSecp224r1VerificationKey2019(ALG.ES224, "ECDSA", "P-224", "SHA-224", SignatureScheme.SHA224WITHECDSA),
    EcdsaSecp256r1VerificationKey2019(ALG.ES256, "ECDSA", "P-256", "SHA-256", SignatureScheme.SHA256WITHECDSA),
    EcdsaSecp384r1VerificationKey2019(ALG.ES384, "ECDSA", "P-384", "SHA-384", SignatureScheme.SHA384WITHECDSA),
    EcdsaSecp521r1VerificationKey2019(ALG.ES512, "ECDSA", "P-521", "SHA-512", SignatureScheme.SHA512WITHECDSA),
    EcdsaSecp256k1VerificationKey2019(ALG.ES256K, "ECDSA", "secp256k1", "SHA-256", SignatureScheme.SHA256WITHECDSA),
    Ed25519VerificationKey2018(ALG.EdDSA, "EDDSA", "Curve25519", "SHA-256", null),
    SM2VerificationKey2019(ALG.SM, "SM2", "SM2P256V1", "SM3", SignatureScheme.SM3WITHSM2);

    private ALG alg;
    private String algType;
    private String curve;
    private String hashMethod;
    private SignatureScheme signatureScheme;

    private PubKeyType(ALG alg, String algType, String curve, String hashMethod, SignatureScheme scheme) {
        this.alg = alg;
        this.algType = algType;
        this.curve = curve;
        this.hashMethod = hashMethod;
        this.signatureScheme = scheme;
        alg.setProofPubKeyType(this);
    }

    public ALG getAlg() {
        return this.alg;
    }

    public String getAlgType() {
        return this.algType;
    }

    public String getCurve() {
        return this.curve;
    }

    public String getHashMethod() {
        return this.hashMethod;
    }

    public SignatureScheme getSignatureScheme() {
        return this.signatureScheme;
    }
}

