/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.dnaid;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.DNAProject.dnaid.CredentialStatus;
import com.github.DNAProject.dnaid.Proof;
import com.github.DNAProject.dnaid.Util;
import com.github.DNAProject.dnaid.jwt.JWTCredential;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;

@JSONType(orders={"@context", "id", "type", "issuer", "issuanceDate", "expirationDate", "credentialSubject", "credentialStatus", "proof"})
public class VerifiableCredential {
    @JSONField(name="@context")
    public String[] context;
    public String id = "urn:uuid:" + UUID.randomUUID().toString();
    public String[] type;
    public Object issuer;
    public String issuanceDate;
    public String expirationDate;
    public Object credentialSubject;
    public CredentialStatus credentialStatus;
    public Proof proof;

    public String fetchIssuerDnaId() {
        return Util.fetchId(this.issuer);
    }

    public byte[] genNeedSignData() {
        Proof proof = this.proof;
        this.proof = this.proof.genNeedSignProof();
        String jsonStr = JSON.toJSONString((Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField});
        this.proof = proof;
        return jsonStr.getBytes();
    }

    public String findSubjectId() {
        return Util.fetchId(this.credentialSubject);
    }

    public static VerifiableCredential deserializeFromJWT(JWTCredential jwtCred) {
        VerifiableCredential credential = new VerifiableCredential();
        credential.context = jwtCred.payload.vc.context;
        credential.id = jwtCred.payload.jti;
        credential.type = jwtCred.payload.vc.type;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (jwtCred.payload.iat > 0L) {
            credential.issuanceDate = formatter.format(new Date(jwtCred.payload.iat * 1000L));
        } else if (jwtCred.payload.nbf > 0L) {
            credential.issuanceDate = formatter.format(new Date(jwtCred.payload.nbf * 1000L));
        }
        if (jwtCred.payload.exp > 0L) {
            credential.expirationDate = formatter.format(new Date(jwtCred.payload.exp * 1000L));
        }
        credential.credentialStatus = jwtCred.payload.vc.credentialStatus;
        if (jwtCred.payload.vc.issuer == null) {
            credential.issuer = jwtCred.payload.iss;
        } else {
            JSONObject jsonIssuer = (JSONObject)JSONObject.toJSON((Object)jwtCred.payload.vc.issuer);
            jsonIssuer.put("id", (Object)jwtCred.payload.iss);
            credential.issuer = jsonIssuer;
        }
        credential.proof = jwtCred.parseProof();
        if (jwtCred.payload.sub != null && !jwtCred.payload.sub.isEmpty()) {
            JSONObject subject = (JSONObject)JSONObject.toJSON((Object)jwtCred.payload.vc.credentialSubject);
            subject.put("id", (Object)jwtCred.payload.sub);
            credential.credentialSubject = subject;
        } else {
            credential.credentialSubject = jwtCred.payload.vc.credentialSubject;
        }
        return credential;
    }
}

