/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.merkle;

import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.UInt256;
import com.github.DNAProject.merkle.TreeHasher;
import com.github.DNAProject.sdk.exception.SDKException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MerkleVerifier {
    private static TreeHasher hasher = new TreeHasher();

    public static boolean VerifyLeafHashInclusion(UInt256 leaf_hash, int leaf_index, UInt256[] proof, UInt256 root_hash, int tree_size) throws Exception {
        if (tree_size <= leaf_index) {
            throw new SDKException(ErrorCode.MerkleVerifierErr);
        }
        UInt256 calculated_root_hash = MerkleVerifier.calculate_root_hash_from_audit_path(leaf_hash, leaf_index, proof, tree_size);
        if (calculated_root_hash.equals(new UInt256())) {
            return false;
        }
        if (!calculated_root_hash.equals(root_hash)) {
            throw new Exception("Constructed root hash differs from provided root hash. Constructed: %x, Expected: " + calculated_root_hash + root_hash);
        }
        return true;
    }

    public static UInt256 calculate_root_hash_from_audit_path(UInt256 leaf_hash, int node_index, UInt256[] audit_path, int tree_size) {
        UInt256 calculated_hash = leaf_hash;
        int pos = 0;
        int path_len = audit_path.length;
        for (int last_node = tree_size - 1; last_node > 0; last_node /= 2) {
            if (pos >= path_len) {
                return new UInt256();
            }
            if (node_index % 2 == 1) {
                calculated_hash = hasher.hash_children(audit_path[pos], calculated_hash);
                ++pos;
            } else if (node_index < last_node) {
                calculated_hash = hasher.hash_children(calculated_hash, audit_path[pos]);
                ++pos;
            }
            node_index /= 2;
        }
        if (pos < path_len) {
            return new UInt256();
        }
        return calculated_hash;
    }

    public static List getProof(UInt256 leaf_hash, int node_index, UInt256[] audit_path, int tree_size) {
        ArrayList nodes = new ArrayList();
        int pos = 0;
        for (int last_node = tree_size - 1; last_node > 0; last_node /= 2) {
            HashMap<String, String> map;
            if (node_index % 2 == 1) {
                map = new HashMap<String, String>();
                map.put("Direction", "Left");
                map.put("TargetHash", audit_path[pos].toHexString());
                nodes.add(map);
                ++pos;
            } else if (node_index < last_node) {
                map = new HashMap();
                map.put("Direction", "Right");
                map.put("TargetHash", audit_path[pos].toHexString());
                nodes.add(map);
                ++pos;
            }
            node_index /= 2;
        }
        return nodes;
    }

    public static boolean Verify(UInt256 leaf_hash, List targetHashes, UInt256 root_hash) throws SDKException {
        UInt256 calculated_hash = leaf_hash;
        for (int i = 0; i < targetHashes.size(); ++i) {
            String direction = (String)((Map)targetHashes.get(i)).get("Direction");
            String tmp = (String)((Map)targetHashes.get(i)).get("TargetHash");
            UInt256 targetHash = UInt256.parse(tmp);
            if (direction.equals("Left")) {
                calculated_hash = hasher.hash_children(targetHash, calculated_hash);
                continue;
            }
            if (direction.equals("Right")) {
                calculated_hash = hasher.hash_children(calculated_hash, targetHash);
                continue;
            }
            throw new SDKException(ErrorCode.TargetHashesErr);
        }
        if (calculated_hash.equals(new UInt256())) {
            return false;
        }
        if (!calculated_hash.equals(root_hash)) {
            throw new SDKException(ErrorCode.ConstructedRootHashErr("Constructed root hash differs from provided root hash. Constructed: %x, Expected: " + calculated_hash + root_hash));
        }
        return true;
    }
}

