/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.sdk.claim;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.DataSignature;
import com.github.DNAProject.crypto.Digest;
import com.github.DNAProject.crypto.SignatureScheme;
import com.github.DNAProject.sdk.claim.Header;
import com.github.DNAProject.sdk.claim.MetaData;
import com.github.DNAProject.sdk.claim.Payload;
import com.github.DNAProject.sdk.claim.SignatureInfo;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Claim {
    private String context = "";
    private String id = UUID.randomUUID().toString();
    private Map<String, Object> claim = new HashMap<String, Object>();
    String ClaimStr = "";

    public Claim(SignatureScheme scheme, Account acct, String ctx, Map claimMap, Map metadata, String publicKeyId) {
        this.context = ctx;
        this.claim.put("Context", this.context);
        if (claimMap != null) {
            this.claim.put("Content", claimMap);
        }
        this.claim.put("Metadata", new MetaData(metadata).getJson());
        this.id = Helper.toHexString(Digest.sha256(JSON.toJSONString(this.claim).getBytes()));
        this.claim.put("Id", this.id);
        this.claim.put("Version", "v1.0");
        DataSignature sign = new DataSignature(scheme, acct, this.getClaim());
        byte[] signature = sign.signature();
        SignatureInfo info = new SignatureInfo("", "", publicKeyId, signature);
        this.claim.put("Signature", info.getJson());
    }

    public Claim(SignatureScheme scheme, Account acct, String ctx, Map clmMap, Map<String, String> metadata, Map clmRevMap, String publicKeyId, long expireTime) throws Exception {
        String iss = metadata.get("Issuer");
        String sub = metadata.get("Subject");
        Header header = new Header("", "", publicKeyId);
        Payload payload = new Payload("v1.0", iss, sub, System.currentTimeMillis() / 1000L, expireTime, ctx, clmMap, clmRevMap);
        String headerStr = JSONObject.toJSONString((Object)header.getJson());
        String payloadStr = JSONObject.toJSONString((Object)payload.getJson());
        byte[] headerBytes = Base64.getEncoder().encode(headerStr.getBytes());
        byte[] payloadBytes = Base64.getEncoder().encode(payloadStr.getBytes());
        DataSignature sign = new DataSignature(scheme, acct, new String(headerBytes) + "." + new String(payloadBytes));
        byte[] signature = sign.signature();
        this.ClaimStr = this.ClaimStr + new String(headerBytes) + "." + new String(payloadBytes) + "." + new String(Base64.getEncoder().encode(signature));
    }

    public String getClaim() {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : this.claim.entrySet()) {
            tmp.put(e.getKey(), e.getValue());
        }
        return JSONObject.toJSONString(tmp);
    }

    public String getClaimStr() {
        return this.ClaimStr;
    }
}

