/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.sdk.manager;

import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.crypto.KeyType;
import com.github.DNAProject.crypto.SignatureScheme;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.kems.ECIESKeyEncapsulation;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.util.encoders.Hex;

public class ECIES {
    public static KeyType keyType = KeyType.ECDSA;
    public static Object[] curveParaSpec = new Object[]{"P-256"};
    public static SignatureScheme signatureScheme = SignatureScheme.SHA256WITHECDSA;
    public static Digest defaultDigest = new SHA256Digest();

    public ECIES(Digest dig) {
        defaultDigest = dig;
    }

    public static void setDigest(Digest dig) {
        defaultDigest = dig;
    }

    public static String[] Encrypt(String pubkey, byte[] msg) throws Exception {
        return ECIES.Encrypt(pubkey, msg, 32);
    }

    public static String[] Encrypt(String pubkey, byte[] msg, int keylen) throws Exception {
        try {
            byte[] ciphertext;
            Account account = new Account(false, Helper.hexToBytes(pubkey));
            ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)((String)curveParaSpec[0]));
            ECDomainParameters ecDomain = new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN());
            AsymmetricCipherKeyPair keys = new AsymmetricCipherKeyPair((AsymmetricKeyParameter)new ECPublicKeyParameters(((BCECPublicKey)account.getPublicKey()).getQ(), ecDomain), null);
            byte[] out = new byte[ecDomain.getCurve().getFieldSize() / 8 * 2 + 1];
            ECIESKeyEncapsulation kem = new ECIESKeyEncapsulation((DerivationFunction)new KDF2BytesGenerator(defaultDigest), new SecureRandom());
            kem.init((CipherParameters)keys.getPublic());
            KeyParameter key1 = (KeyParameter)kem.encrypt(out, keylen);
            byte[] IV = Hex.decode((String)ECIES.getRandomString(keylen));
            try {
                Cipher en = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
                SecretKeySpec key = new SecretKeySpec(key1.getKey(), "AES");
                en.init(1, (Key)key, new IvParameterSpec(IV));
                ciphertext = en.doFinal(msg);
            }
            catch (Exception e) {
                throw new Exception("AES failed initialisation - " + e.toString(), e);
            }
            return new String[]{Helper.toHexString(IV), Helper.toHexString(out), Helper.toHexString(ciphertext)};
        }
        catch (Exception e) {
            throw new Exception("Encrypt failed initialisation - " + e.toString(), e);
        }
    }

    public static byte[] Decrypt(Account account, String[] params) throws Exception {
        if (params.length != 3) {
            throw new Exception(ErrorCode.ParamError);
        }
        return ECIES.Decrypt(account.serializePrivateKey(), Helper.hexToBytes(params[0]), Helper.hexToBytes(params[1]), Helper.hexToBytes(params[2]), 32);
    }

    public static byte[] Decrypt(String prikey, String[] params) throws Exception {
        if (params.length != 3) {
            throw new Exception(ErrorCode.ParamError);
        }
        return ECIES.Decrypt(Helper.hexToBytes(prikey), Helper.hexToBytes(params[0]), Helper.hexToBytes(params[1]), Helper.hexToBytes(params[2]), 32);
    }

    public static byte[] Decrypt(byte[] prikey, byte[] IV, byte[] key_cxt, byte[] ciphertext) throws Exception {
        return ECIES.Decrypt(prikey, IV, key_cxt, ciphertext, 32);
    }

    public static byte[] Decrypt(byte[] prikey, byte[] IV, byte[] key_cxt, byte[] ciphertext, int keylen) throws Exception {
        try {
            byte[] plaintext;
            Account account = new Account(prikey, signatureScheme);
            ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)((String)curveParaSpec[0]));
            ECDomainParameters ecDomain = new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN());
            AsymmetricCipherKeyPair keys = new AsymmetricCipherKeyPair(null, (AsymmetricKeyParameter)new ECPrivateKeyParameters(((BCECPrivateKey)account.getPrivateKey()).getD(), ecDomain));
            byte[] out = key_cxt;
            ECIESKeyEncapsulation kem = new ECIESKeyEncapsulation((DerivationFunction)new KDF2BytesGenerator(defaultDigest), new SecureRandom());
            kem.init((CipherParameters)keys.getPrivate());
            KeyParameter key1 = (KeyParameter)kem.decrypt(out, keylen);
            try {
                Cipher dec = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
                SecretKeySpec key = new SecretKeySpec(key1.getKey(), "AES");
                dec.init(2, (Key)key, new IvParameterSpec(IV));
                plaintext = dec.doFinal(ciphertext);
            }
            catch (Exception e) {
                throw new Exception("AES failed initialisation - " + e.toString(), e);
            }
            return plaintext;
        }
        catch (Exception e) {
            throw new Exception("AES failed initialisation - " + e.toString(), e);
        }
    }

    public static String getRandomString(int length) {
        String KeyStr = "ABCDEF0123456789";
        StringBuffer sb = new StringBuffer();
        int len = KeyStr.length();
        for (int i = 0; i < length; ++i) {
            sb.append(KeyStr.charAt((int)Math.round(Math.random() * (double)(len - 1))));
        }
        return sb.toString();
    }
}

