/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.sdk.manager;

import com.alibaba.fastjson.JSON;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.network.exception.RpcException;
import com.github.DNAProject.network.rpc.Interfaces;
import java.util.HashMap;
import java.util.Map;

public class SignServer {
    private Interfaces rpcClient;
    private String url = "";

    public SignServer(String url) throws Exception {
        this.url = url;
        this.rpcClient = new Interfaces(url);
    }

    public Object sendSigRawTx(String rawTx) throws Exception {
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("jsonrpc", "2.0");
        req.put("method", "sigrawtx");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("raw_tx", rawTx);
        req.put("params", params);
        req.put("id", 1);
        return this.send(req);
    }

    public Object sendMultiSigRawTx(String rawTx, int m, String[] pubkeys) throws Exception {
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("jsonrpc", "2.0");
        req.put("method", "sigmutilrawtx");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("raw_tx", rawTx);
        params.put("m", m);
        params.put("pub_keys", pubkeys);
        req.put("params", params);
        req.put("id", 1);
        return this.send(req);
    }

    public Object sendSigTransferTx(String asset, String from, String to, long amount, long gasLimit, long gasPrice) throws Exception {
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("jsonrpc", "2.0");
        req.put("method", "sigtransfertx");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("asset", asset);
        params.put("from", from);
        params.put("to", to);
        params.put("amount", amount);
        params.put("gas_limit", gasLimit);
        params.put("gas_price", gasPrice);
        req.put("params", params);
        req.put("id", 1);
        return this.send(req);
    }

    public Object sendSigNativeInvokeTx(String contractAddr, String method, int version, long gasLimit, long gasPrice, Map parameters) throws Exception {
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("jsonrpc", "2.0");
        req.put("method", "sigtransfertx");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("address", contractAddr);
        params.put("method", method);
        params.put("version", version);
        params.put("gas_limit", gasLimit);
        params.put("gas_price", gasPrice);
        params.put("params", parameters);
        req.put("params", params);
        req.put("id", 1);
        return this.send(req);
    }

    public Object sendSigNeoInvokeTx(String contractAddr, int version, long gasLimit, long gasPrice, Map parameters) throws Exception {
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("jsonrpc", "2.0");
        req.put("method", "sigtransfertx");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("address", contractAddr);
        params.put("version", version);
        params.put("gas_limit", gasLimit);
        params.put("gas_price", gasPrice);
        params.put("params", parameters);
        req.put("params", params);
        req.put("id", 1);
        return this.send(req);
    }

    private Object send(Map req) throws Exception {
        Map response = (Map)this.rpcClient.send(req);
        System.out.println(response);
        if (response == null) {
            throw new RpcException(0, ErrorCode.ConnectUrlErr(this.url + "response is null. maybe is connect error"));
        }
        if ((Integer)response.get("error_code") == 0) {
            return response.get("result");
        }
        throw new RpcException(0, JSON.toJSONString((Object)response));
    }
}

