/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.smartcontract;

import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.core.payload.InvokeCode;
import com.github.DNAProject.dnaid.DnaId2;
import com.github.DNAProject.sdk.exception.SDKException;
import com.github.DNAProject.smartcontract.neovm.ClaimRecord;
import com.github.DNAProject.smartcontract.neovm.CredentialRecord;
import com.github.DNAProject.smartcontract.neovm.Oep4;
import com.github.DNAProject.smartcontract.neovm.Oep5;
import com.github.DNAProject.smartcontract.neovm.Oep8;
import com.github.DNAProject.smartcontract.neovm.Record;
import com.github.DNAProject.smartcontract.neovm.abi.AbiFunction;
import com.github.DNAProject.smartcontract.neovm.abi.BuildParams;

public class NeoVm {
    private Oep4 oep4Tx = null;
    private Oep5 oep5Tx = null;
    private Oep8 oep8Tx = null;
    private Record recordTx = null;
    private ClaimRecord claimRecordTx = null;
    private CredentialRecord credentialRecordTx = null;
    private DnaId2 dnaId2 = null;
    private DnaSdk sdk;

    public NeoVm(DnaSdk sdk) {
        this.sdk = sdk;
    }

    public Oep4 oep4() {
        if (this.oep4Tx == null) {
            this.oep4Tx = new Oep4(this.sdk);
        }
        return this.oep4Tx;
    }

    public Oep5 oep5() {
        if (this.oep5Tx == null) {
            this.oep5Tx = new Oep5(this.sdk);
        }
        return this.oep5Tx;
    }

    public Oep8 oep8() {
        if (this.oep8Tx == null) {
            this.oep8Tx = new Oep8(this.sdk);
        }
        return this.oep8Tx;
    }

    public Record record() {
        if (this.recordTx == null) {
            this.recordTx = new Record(this.sdk);
        }
        return this.recordTx;
    }

    public ClaimRecord claimRecord() {
        if (this.claimRecordTx == null) {
            this.claimRecordTx = new ClaimRecord(this.sdk);
        }
        return this.claimRecordTx;
    }

    public CredentialRecord credentialRecord() {
        if (this.credentialRecordTx == null) {
            this.credentialRecordTx = new CredentialRecord(this.sdk);
        }
        return this.credentialRecordTx;
    }

    public DnaId2 dnaId2() throws Exception {
        if (this.dnaId2 == null) {
            this.dnaId2 = new DnaId2("", null, this.credentialRecordTx, this.sdk.nativevm().dnaId());
        }
        return this.dnaId2;
    }

    public DnaId2 dnaId2(String dnaId, Account signer) throws Exception {
        if (this.dnaId2 == null) {
            this.dnaId2 = new DnaId2(dnaId, signer, this.credentialRecordTx, this.sdk.nativevm().dnaId());
        } else {
            this.dnaId2.updateDnaIdAndSigner(dnaId, signer);
        }
        return this.dnaId2;
    }

    public Object sendTransaction(String contractAddr, Account acct, Account payerAcct, long gaslimit, long gasprice, AbiFunction func, boolean preExec) throws Exception {
        boolean b;
        byte[] params = func != null ? BuildParams.serializeAbiFunction(func) : new byte[]{};
        if (preExec) {
            InvokeCode tx = this.sdk.vm().makeInvokeCodeTransaction(contractAddr, null, params, null, 0L, 0L);
            if (acct != null) {
                this.sdk.signTx(tx, new Account[][]{{acct}});
            }
            Object obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString());
            return obj;
        }
        String payer = payerAcct.getAddressU160().toBase58();
        InvokeCode tx = this.sdk.vm().makeInvokeCodeTransaction(contractAddr, null, params, payer, gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{acct}});
        if (!acct.getAddressU160().toBase58().equals(payerAcct.getAddressU160().toBase58())) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (!(b = this.sdk.getConnect().sendRawTransaction(tx.toHexString()))) {
            throw new SDKException(ErrorCode.SendRawTxError);
        }
        return tx.hash().toHexString();
    }
}

