/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.smartcontract;

import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.Common;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.payload.DeployCode;
import com.github.DNAProject.core.payload.InvokeCode;
import com.github.DNAProject.core.scripts.ScriptBuilder;
import com.github.DNAProject.core.scripts.ScriptOp;
import com.github.DNAProject.core.transaction.Attribute;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.sdk.exception.SDKException;
import java.math.BigInteger;
import java.util.Random;

public class Vm {
    private DnaSdk sdk;
    private String contractAddress = null;
    public static String NATIVE_INVOKE_NAME = "System.Native.Invoke";

    public String getCodeAddress() {
        return this.contractAddress;
    }

    public void setCodeAddress(String codeHash) {
        this.contractAddress = codeHash.replace("0x", "");
    }

    public Vm(DnaSdk sdk) {
        this.sdk = sdk;
    }

    public DeployCode makeDeployCodeTransaction(String codeStr, boolean needStorage, String name, String codeVersion, String author, String email, String desp, String payer, long gaslimit, long gasprice) throws SDKException {
        if (name == null || name.equals("") || codeVersion == null || codeVersion.equals("") || author == null || author.equals("") || email == null || email.equals("") || desp == null || desp.equals("")) {
            throw new SDKException(ErrorCode.OtherError("param error,can not be empty"));
        }
        DeployCode tx = new DeployCode();
        if (payer != null) {
            tx.payer = Address.decodeBase58(payer.replace(Common.diddna, ""));
        }
        tx.attributes = new Attribute[0];
        tx.nonce = new Random().nextInt();
        tx.code = Helper.hexToBytes(codeStr);
        tx.version = codeVersion;
        tx.needStorage = needStorage;
        tx.name = name;
        tx.author = author;
        tx.email = email;
        tx.gasLimit = gaslimit;
        tx.gasPrice = gasprice;
        tx.description = desp;
        return tx;
    }

    public InvokeCode makeInvokeCodeTransaction(String codeAddr, String method, byte[] params, String payer, long gaslimit, long gasprice) throws SDKException {
        params = Helper.addBytes(params, new byte[]{103});
        params = Helper.addBytes(params, Address.parse(codeAddr).toArray());
        InvokeCode tx = new InvokeCode();
        tx.attributes = new Attribute[0];
        tx.nonce = new Random().nextInt();
        tx.code = params;
        tx.gasLimit = gaslimit;
        tx.gasPrice = gasprice;
        if (payer != null) {
            tx.payer = Address.decodeBase58(payer.replace(Common.diddna, ""));
        }
        return tx;
    }

    public InvokeCode makeInvokeCodeTransaction(byte[] params, String payer, long gaslimit, long gasprice) throws SDKException {
        InvokeCode tx = new InvokeCode();
        tx.attributes = new Attribute[0];
        tx.nonce = new Random().nextInt();
        tx.code = params;
        tx.gasLimit = gaslimit;
        tx.gasPrice = gasprice;
        if (payer != null) {
            tx.payer = Address.decodeBase58(payer.replace(Common.diddna, ""));
        }
        return tx;
    }

    public Transaction buildNativeParams(Address codeAddr, String initMethod, byte[] args, String payer, long gaslimit, long gasprice) throws SDKException {
        ScriptBuilder sb = new ScriptBuilder();
        if (args.length > 0) {
            sb.add(args);
        }
        sb.emitPushByteArray(initMethod.getBytes());
        sb.emitPushByteArray(codeAddr.toArray());
        sb.emitPushInteger(BigInteger.valueOf(0L));
        sb.emit(ScriptOp.OP_SYSCALL);
        sb.emitPushByteArray(NATIVE_INVOKE_NAME.getBytes());
        InvokeCode tx = this.makeInvokeCodeTransaction(sb.toArray(), payer, gaslimit, gasprice);
        return tx;
    }
}

