/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.smartcontract.nativevm;

import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import com.github.DNAProject.io.Serializable;
import java.io.IOException;

class FuncsToRoleParam
implements Serializable {
    byte[] contractAddr;
    byte[] adminDnaID;
    byte[] role;
    String[] funcNames;
    long keyNo;

    FuncsToRoleParam(byte[] contractAddr, byte[] adminDnaID, byte[] role, String[] funcNames, long keyNo) {
        this.contractAddr = contractAddr;
        this.adminDnaID = adminDnaID;
        this.role = role;
        this.funcNames = funcNames;
        this.keyNo = keyNo;
    }

    @Override
    public void deserialize(BinaryReader reader) throws IOException {
        this.contractAddr = reader.readVarBytes();
        this.adminDnaID = reader.readVarBytes();
        this.role = reader.readVarBytes();
        int length = (int)reader.readVarInt();
        this.funcNames = new String[length];
        for (int i = 0; i < length; ++i) {
            this.funcNames[i] = reader.readVarString();
        }
        this.keyNo = reader.readVarInt();
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.writeVarBytes(this.contractAddr);
        writer.writeVarBytes(this.adminDnaID);
        writer.writeVarBytes(this.role);
        writer.writeVarInt(this.funcNames.length);
        for (String name : this.funcNames) {
            writer.writeVarString(name);
        }
        writer.writeVarInt(this.keyNo);
    }
}

