/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.smartcontract.nativevm;

import com.alibaba.fastjson.JSONObject;
import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.globalparams.Params;
import com.github.DNAProject.core.payload.InvokeCode;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.network.exception.ConnectorException;
import com.github.DNAProject.sdk.exception.SDKException;
import com.github.DNAProject.smartcontract.nativevm.abi.NativeBuildParams;
import com.github.DNAProject.smartcontract.nativevm.abi.Struct;
import java.io.IOException;
import java.util.ArrayList;

public class GlobalParams {
    private DnaSdk sdk;
    private final String contractAddress = "0000000000000000000000000000000000000004";

    public GlobalParams(DnaSdk sdk) {
        this.sdk = sdk;
    }

    public boolean init() throws Exception {
        InvokeCode tx = this.sdk.vm().makeInvokeCodeTransaction("0000000000000000000000000000000000000004", "init", new byte[0], null, 0L, 0L);
        return this.sdk.getConnect().sendRawTransaction(tx.toHexString());
    }

    public String transferAdmin(Account adminAccount, Address newAdminAddr, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        if (adminAccount == null || newAdminAddr == null || payerAcct == null) {
            throw new SDKException("parameter should not be null");
        }
        if (gaslimit < 0L || gasprice < 0L) {
            throw new SDKException("gaslimit or gasprice should not be less than 0");
        }
        Transaction tx = this.makeTransferAdmin(newAdminAddr, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{adminAccount}});
        if (!adminAccount.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toHexString();
        }
        return null;
    }

    public String transferAdmin(int M, Account[] accounts, Address newAdminAddr, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (accounts.length == 0 || newAdminAddr == null || payerAcct == null) {
            throw new SDKException("parameter should not be null");
        }
        if (accounts.length < M) {
            throw new SDKException("the accounts length should not be less than M");
        }
        if (gaslimit < 0L || gasprice < 0L) {
            throw new SDKException("gaslimit or gasprice should not be less than 0");
        }
        Transaction tx = this.makeTransferAdmin(newAdminAddr, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{accounts}, new int[]{M});
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toHexString();
        }
        return null;
    }

    public Transaction makeTransferAdmin(Address newAdminAddr, String payerAddr, long gaslimit, long gasprice) throws SDKException {
        if (newAdminAddr == null || payerAddr == null || payerAddr.equals("")) {
            throw new SDKException("parameter should not be null");
        }
        if (gaslimit < 0L || gasprice < 0L) {
            throw new SDKException("gaslimit or gasprice should not be less than 0");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Struct struct = new Struct();
        struct.add(new Object[]{newAdminAddr.toArray()});
        list.add(struct);
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000004")), "transferAdmin", arg, payerAddr, gaslimit, gasprice);
        return tx;
    }

    public String acceptAdmin(Account account, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        if (account == null || payerAcct == null) {
            throw new SDKException("parameter should not be null");
        }
        if (gaslimit < 0L || gasprice < 0L) {
            throw new SDKException("gaslimit or gasprice should not be less than 0");
        }
        Transaction tx = this.makeAcceptAdmin(account.getAddressU160(), payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{account}});
        if (!account.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toHexString();
        }
        return null;
    }

    public String acceptAdmin(Address multiAddr, int M, Account[] accounts, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (accounts.length == 0 || multiAddr == null || payerAcct == null) {
            throw new SDKException("parameter should not be null");
        }
        if (accounts.length < M) {
            throw new SDKException("the accounts length should not be less than M");
        }
        if (gaslimit < 0L || gasprice < 0L) {
            throw new SDKException("gaslimit or gasprice should not be less than 0");
        }
        Transaction tx = this.makeAcceptAdmin(multiAddr, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{accounts}, new int[]{M});
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toHexString();
        }
        return null;
    }

    public Transaction makeAcceptAdmin(Address multiAddr, String payerAddr, long gaslimit, long gasprice) throws SDKException {
        if (multiAddr == null || payerAddr == null || payerAddr.equals("")) {
            throw new SDKException("parameter should not be null");
        }
        if (gaslimit < 0L || gasprice < 0L) {
            throw new SDKException("gaslimit or gasprice should not be less than 0");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Struct struct = new Struct();
        struct.add(new Object[]{multiAddr.toArray()});
        list.add(struct);
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000004")), "transferAdmin", arg, payerAddr, gaslimit, gasprice);
        return tx;
    }

    public String getGlobalParam(String[] paramNameList) throws SDKException, ConnectorException, IOException {
        if (paramNameList.length == 0) {
            throw new SDKException("parameter should not be less than 0");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Struct struct = new Struct();
        struct.add(paramNameList.length);
        for (int i = 0; i < paramNameList.length; ++i) {
            struct.add(paramNameList[i]);
        }
        list.add(struct);
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000004")), "getGlobalParam", arg, null, 0L, 0L);
        Object obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString());
        String res = ((JSONObject)obj).getString("Result");
        return res;
    }

    public String setGlobalParam(Account operatorAccount, Params params, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        if (operatorAccount == null || params == null || payerAcct == null) {
            throw new SDKException("parameter should not be null");
        }
        if (gaslimit < 0L || gasprice < 0L) {
            throw new SDKException("gaslimit or gasprice should not be less than 0");
        }
        Transaction tx = this.makeSetGlobalParam(params, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{operatorAccount}});
        if (!operatorAccount.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toHexString();
        }
        return null;
    }

    public String setGlobalParam(int M, Account[] operatorAccounts, Params params, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (operatorAccounts.length == 0 || params == null || payerAcct == null) {
            throw new SDKException("parameter should not be null");
        }
        if (operatorAccounts.length < M) {
            throw new SDKException("the operatorAccounts length should not be less than M");
        }
        if (gaslimit < 0L || gasprice < 0L) {
            throw new SDKException("gaslimit or gasprice should not be less than 0");
        }
        Transaction tx = this.makeSetGlobalParam(params, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{operatorAccounts}, new int[]{M});
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toHexString();
        }
        return null;
    }

    public Transaction makeSetGlobalParam(Params params, String payerAddr, long gaslimit, long gasprice) throws SDKException {
        if (params == null || payerAddr == null || payerAddr.equals("")) {
            throw new SDKException("parameter should not be null");
        }
        if (gaslimit < 0L || gasprice < 0L) {
            throw new SDKException("gaslimit or gasprice should not be less than 0");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Struct struct = new Struct();
        struct.add(params.params.length);
        for (int i = 0; i < params.params.length; ++i) {
            struct.add(params.params[i].key, params.params[i].value);
        }
        list.add(struct);
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000004")), "setGlobalParam", arg, payerAddr, gaslimit, gasprice);
        return tx;
    }

    public String setOperator(Account adminAccount, Address addr, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        if (adminAccount == null || addr == null || payerAcct == null) {
            throw new SDKException("parameter should not be null");
        }
        if (gaslimit < 0L || gasprice < 0L) {
            throw new SDKException("gaslimit or gasprice should not be less than 0");
        }
        Transaction tx = this.makeSetOperator(addr, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{adminAccount}});
        if (!adminAccount.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toHexString();
        }
        return null;
    }

    public String setOperator(int M, Account[] accounts, Address addr, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (accounts.length == 0 || addr == null || payerAcct == null) {
            throw new SDKException("parameter should not be null");
        }
        if (accounts.length < M) {
            throw new SDKException("accounts length should not be less than M");
        }
        if (gaslimit < 0L || gasprice < 0L) {
            throw new SDKException("gaslimit or gasprice should not be less than 0");
        }
        Transaction tx = this.makeSetOperator(addr, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{accounts}, new int[]{M});
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toHexString();
        }
        return null;
    }

    public Transaction makeSetOperator(Address addr, String payerAddr, long gaslimit, long gasprice) throws SDKException {
        if (addr == null || payerAddr == null || payerAddr.equals("")) {
            throw new SDKException("parameter should not be null");
        }
        if (gaslimit < 0L || gasprice < 0L) {
            throw new SDKException("gaslimit or gasprice should not be less than 0");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Struct struct = new Struct();
        struct.add(new Object[]{addr.toArray()});
        list.add(struct);
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000004")), "transferAdmin", arg, payerAddr, gaslimit, gasprice);
        return tx;
    }

    public String createSnapshot(Account operatorAccount, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        if (operatorAccount == null || payerAcct == null) {
            throw new SDKException("parameter should not be null");
        }
        if (gaslimit < 0L || gasprice < 0L) {
            throw new SDKException("gaslimit or gasprice should not be less than 0");
        }
        Transaction tx = this.makeCreateSnapshot(payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{operatorAccount}});
        if (!operatorAccount.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toHexString();
        }
        return null;
    }

    public String createSnapshot(int M, Account[] operatorAccounts, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (operatorAccounts.length == 0 || payerAcct == null) {
            throw new SDKException("parameter should not be null");
        }
        if (operatorAccounts.length < M) {
            throw new SDKException("accounts length should not be less than M");
        }
        if (gaslimit < 0L || gasprice < 0L) {
            throw new SDKException("gaslimit or gasprice should not be less than 0");
        }
        Transaction tx = this.makeCreateSnapshot(payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{operatorAccounts}, new int[]{M});
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toHexString();
        }
        return null;
    }

    public Transaction makeCreateSnapshot(String payerAddr, long gaslimit, long gasprice) throws SDKException {
        if (payerAddr == null || payerAddr.equals("")) {
            throw new SDKException("parameter should not be null");
        }
        if (gaslimit < 0L || gasprice < 0L) {
            throw new SDKException("gaslimit or gasprice should not be less than 0");
        }
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000004")), "createSnapshot", new byte[]{0}, payerAddr, gaslimit, gasprice);
        return tx;
    }
}

