/*
 * Decompiled with CFR 0.152.
 */
package example.gas;

import com.alibaba.fastjson.JSON;
import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.asset.State;
import com.github.DNAProject.core.transaction.Transaction;
import example.gas.Balance;
import example.gas.Event;
import example.gas.States;
import example.gas.UserAcct;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class ExchangeDemo {
    public static final String INIT_ACCT_ADDR = "Ad4pjz2bqep4RhQrUAzMuZJkBC3qJ1tZuT";
    public static final String INIT_ACCT_SALT = "OkX96EG0OaCNUFD3hdc50Q==";
    public static final String FEE_PROVIDER = "AS3SCXw8GKTEeXpdwVw7EcC4rqSebFYpfb";
    public static final String FEE_PROVIDER_SALT = "KvKkxNOGm4q4bLkD8TS2PA==";
    public static final String PWD = "123456";
    public static final String MUTI_SIG_ACCT_SEED1_ADDR = "AK98G45DhmPXg4TFPG1KjftvkEaHbU8SHM";
    public static final String MUTI_SIG_ACCT_SEED1_SALT = "rD4ewxv4qHH8FbUkUv6ePQ==";
    public static final String MUTI_SIG_ACCT_SEED2_ADDR = "ALerVnMj3eNk9xe8BnQJtoWvwGmY3x4KMi";
    public static final String MUTI_SIG_ACCT_SEED2_SALT = "1K8a7joYQ+iwj3/+wGICrw==";
    public static final String MUTI_SIG_ACCT_SEED3_ADDR = "AKmowTi8NcAMjZrg7ZNtSQUtnEgdaC65wG";
    public static final String MUTI_SIG_ACCT_SEED3_SALT = "b9oBYBIPvZMw66q1ky+JDQ==";
    public static final String WITHDRAW_ADDRESS = "AZbcPX7HyJTWjqogZhnr2qDTh6NNksGSE6";
    public static String GAS_NATIVE_ADDRESS = "";

    public static void main(String[] args) {
        try {
            final HashMap<String, UserAcct> database = new HashMap<String, UserAcct>();
            final DnaSdk dnaSdk = ExchangeDemo.getDnaSdk();
            GAS_NATIVE_ADDRESS = Helper.reverse(dnaSdk.nativevm().gas().getContractAddress());
            ExchangeDemo.printlog("++++ starting simulate exchange process ...========");
            ExchangeDemo.printlog("++++ 1. create a random account for user ====");
            String id1 = "id1";
            Account acct1 = new Account(dnaSdk.defaultSignScheme);
            String pubkey = acct1.getAddressU160().toBase58();
            byte[] privkey = acct1.serializePrivateKey();
            ExchangeDemo.printlog("++++ public key is " + acct1.getAddressU160().toBase58());
            UserAcct usr = ExchangeDemo.getNewUserAcct(id1, pubkey, privkey, BigInteger.valueOf(0L), BigInteger.valueOf(0L));
            usr.withdrawAddr = WITHDRAW_ADDRESS;
            database.put(acct1.getAddressU160().toBase58(), usr);
            final Account feeAct = dnaSdk.getWalletMgr().getAccount(FEE_PROVIDER, PWD, Base64.getDecoder().decode(FEE_PROVIDER_SALT));
            Account mutiSeedAct1 = dnaSdk.getWalletMgr().getAccount(MUTI_SIG_ACCT_SEED1_ADDR, PWD, Base64.getDecoder().decode(MUTI_SIG_ACCT_SEED1_SALT));
            Account mutiSeedAct2 = dnaSdk.getWalletMgr().getAccount(MUTI_SIG_ACCT_SEED2_ADDR, PWD, Base64.getDecoder().decode(MUTI_SIG_ACCT_SEED2_SALT));
            Account mutiSeedAct3 = dnaSdk.getWalletMgr().getAccount(MUTI_SIG_ACCT_SEED3_ADDR, PWD, Base64.getDecoder().decode(MUTI_SIG_ACCT_SEED3_SALT));
            final Address mainAccountAddr = Address.addressFromMultiPubKeys(3, mutiSeedAct1.serializePublicKey(), mutiSeedAct2.serializePublicKey(), mutiSeedAct3.serializePublicKey());
            ExchangeDemo.printlog("++++ Main Account Address is :" + mainAccountAddr.toBase58());
            Thread t = new Thread(new Runnable(){
                long lastblocknum = 0L;

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                int height;
                                if ((long)(height = dnaSdk.getConnect().getBlockHeight()) > this.lastblocknum) {
                                    ExchangeDemo.printlog("====== new block sync :" + height);
                                    Object event = dnaSdk.getConnect().getSmartCodeEvent(height);
                                    if (event == null) {
                                        this.lastblocknum = height;
                                        Thread.sleep(1000L);
                                        continue;
                                    }
                                    ExchangeDemo.printlog("====== event is " + event.toString());
                                    List events = JSON.parseArray((String)event.toString(), Event.class);
                                    if (events == null) {
                                        this.lastblocknum = height;
                                        Thread.sleep(1000L);
                                        continue;
                                    }
                                    if (events.size() > 0) {
                                        for (Event ev : events) {
                                            ExchangeDemo.printlog("===== State:" + ev.getState());
                                            ExchangeDemo.printlog("===== TxHash:" + ev.getTxHash());
                                            ExchangeDemo.printlog("===== GasConsumed:" + ev.getGasConsumed());
                                            for (States state : ev.notify) {
                                                ExchangeDemo.printlog("===== Notify - ContractAddress:" + state.getContractAddress());
                                                ExchangeDemo.printlog("===== Notify - States[0]:" + state.getStates()[0]);
                                                ExchangeDemo.printlog("===== Notify - States[1]:" + state.getStates()[1]);
                                                ExchangeDemo.printlog("===== Notify - States[2]:" + state.getStates()[2]);
                                                ExchangeDemo.printlog("===== Notify - States[3]:" + state.getStates()[3]);
                                                if (ev.getState() != 1) continue;
                                                Set keys = database.keySet();
                                                if ("transfer".equals(state.getStates()[0]) && keys.contains(state.getStates()[2])) {
                                                    BigInteger amount = new BigInteger(state.getStates()[3].toString());
                                                    if (GAS_NATIVE_ADDRESS.equals(state.getContractAddress())) {
                                                        ExchangeDemo.printlog("===== charge GAS :" + state.getStates()[2] + " ,amount:" + amount);
                                                        ((UserAcct)database.get((Object)state.getStates()[2])).gasBalance = amount.add(((UserAcct)database.get((Object)state.getStates()[2])).gasBalance);
                                                    }
                                                }
                                                if (!"transfer".equals(state.getStates()[0]) || !mainAccountAddr.toBase58().equals(state.getStates()[1])) continue;
                                                for (UserAcct ua : database.values()) {
                                                    if (!ua.withdrawAddr.equals(state.getStates()[2])) continue;
                                                    BigInteger amount = new BigInteger(state.getStates()[3].toString());
                                                    if (!GAS_NATIVE_ADDRESS.equals(state.getContractAddress())) continue;
                                                    ExchangeDemo.printlog("===== widtdraw " + amount + " gas to " + ua.withdrawAddr + " confirmed!");
                                                }
                                            }
                                        }
                                    }
                                    this.lastblocknum = height;
                                }
                                Thread.sleep(1000L);
                            }
                        }
                        catch (Exception e) {
                            ExchangeDemo.printlog("exception 1:" + e.getMessage());
                            continue;
                        }
                        break;
                    }
                }
            });
            Thread t2 = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            Set keys = database.keySet();
                            ArrayList<Account> gasAccts = new ArrayList<Account>();
                            ArrayList<State> gasStates = new ArrayList<State>();
                            for (String key : keys) {
                                Object balance = dnaSdk.getConnect().getBalance(key);
                                ExchangeDemo.printlog("----- balance of " + key + " : " + balance);
                                Balance b = (Balance)JSON.parseObject((String)balance.toString(), Balance.class);
                                BigInteger gasbalance = new BigInteger(b.gas);
                                if (gasbalance.compareTo(new BigInteger("0")) <= 0) continue;
                                UserAcct ua = (UserAcct)database.get(key);
                                Account acct = new Account(ua.privkey, dnaSdk.defaultSignScheme);
                                gasAccts.add(acct);
                                State st = new State(Address.addressFromPubKey(acct.serializePublicKey()), mainAccountAddr, ua.gasBalance.longValue());
                                gasStates.add(st);
                            }
                            if (gasStates.size() > 0) {
                                ExchangeDemo.printlog("----- Will collect gas to main wallet");
                                Transaction gasTx = dnaSdk.nativevm().gas().makeTransfer(gasStates.toArray(new State[gasStates.size()]), ExchangeDemo.FEE_PROVIDER, 30000L, 0L);
                                for (Account act : gasAccts) {
                                    dnaSdk.addSign(gasTx, act);
                                }
                                dnaSdk.addSign(gasTx, feeAct);
                                dnaSdk.getConnect().sendRawTransaction(gasTx.toHexString());
                            }
                            Thread.sleep(10000L);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ExchangeDemo.printlog("exception 2:" + e.getMessage());
                        return;
                    }
                }
            });
            t.start();
            t2.start();
            Thread.sleep(2000L);
            ExchangeDemo.printlog("++++ 2. charge some gas to acct1 from init account");
            Account initAccount = dnaSdk.getWalletMgr().getAccount(INIT_ACCT_ADDR, PWD, Base64.getDecoder().decode(INIT_ACCT_SALT));
            State st = new State(initAccount.getAddressU160(), acct1.getAddressU160(), 1000L);
            Transaction tx = dnaSdk.nativevm().gas().makeTransfer(new State[]{st}, FEE_PROVIDER, 30000L, 0L);
            dnaSdk.addSign(tx, initAccount);
            dnaSdk.addSign(tx, feeAct);
            dnaSdk.getConnect().sendRawTransaction(tx.toHexString());
            String txhash = tx.hash().toHexString();
            ExchangeDemo.printlog("++++ txhash :" + txhash);
            Object event = dnaSdk.getConnect().getMemPoolTxState(txhash);
            ExchangeDemo.printlog(event.toString());
            ExchangeDemo.printlog("++++ 3. charge some gas to acct1 from init account");
            st = new State(initAccount.getAddressU160(), acct1.getAddressU160(), 1200L);
            tx = dnaSdk.nativevm().gas().makeTransfer(new State[]{st}, FEE_PROVIDER, 30000L, 0L);
            dnaSdk.addSign(tx, initAccount);
            dnaSdk.addSign(tx, feeAct);
            dnaSdk.getConnect().sendRawTransaction(tx.toHexString());
            Thread.sleep(15000L);
            ExchangeDemo.printlog("++++ withdraw 500 onts to " + usr.withdrawAddr);
            BigInteger wdAmount = new BigInteger("500");
            ExchangeDemo.printlog("++++ withdraw 500 gas to " + usr.withdrawAddr);
            wdAmount = new BigInteger("500");
            if (usr.gasBalance.compareTo(wdAmount) > 0) {
                ((UserAcct)database.get((Object)usr.address)).gasBalance = ((UserAcct)database.get((Object)usr.address)).gasBalance.subtract(wdAmount);
                ExchangeDemo.printlog("++++  " + usr.address + " gas balance : " + ((UserAcct)database.get((Object)usr.address)).gasBalance);
                State wdSt = new State(mainAccountAddr, Address.decodeBase58(usr.withdrawAddr), 500L);
                Transaction wdTx = dnaSdk.nativevm().gas().makeTransfer(new State[]{wdSt}, FEE_PROVIDER, 30000L, 0L);
                dnaSdk.addMultiSign(wdTx, 3, (byte[][])new byte[][]{mutiSeedAct1.serializePublicKey(), mutiSeedAct2.serializePublicKey(), mutiSeedAct3.serializePublicKey()}, mutiSeedAct1);
                dnaSdk.addMultiSign(wdTx, 3, (byte[][])new byte[][]{mutiSeedAct1.serializePublicKey(), mutiSeedAct2.serializePublicKey(), mutiSeedAct3.serializePublicKey()}, mutiSeedAct2);
                dnaSdk.addMultiSign(wdTx, 3, (byte[][])new byte[][]{mutiSeedAct1.serializePublicKey(), mutiSeedAct2.serializePublicKey(), mutiSeedAct3.serializePublicKey()}, mutiSeedAct3);
                dnaSdk.addSign(wdTx, feeAct);
                dnaSdk.getConnect().sendRawTransaction(wdTx.toHexString());
            }
            Object balance = dnaSdk.getConnect().getBalance(mainAccountAddr.toBase58());
            ExchangeDemo.printlog("++++ before claime gas ,balance of " + mainAccountAddr.toBase58() + " is " + balance);
            String uGasAmt = dnaSdk.nativevm().gas().unboundGas(mainAccountAddr.toBase58());
            ExchangeDemo.printlog("++++ unclaimed gas is " + uGasAmt);
            if (new BigInteger(uGasAmt).compareTo(new BigInteger("0")) > 0) {
                tx = dnaSdk.nativevm().gas().makeWithdrawGas(mainAccountAddr.toBase58(), mainAccountAddr.toBase58(), new BigInteger(uGasAmt).longValue(), FEE_PROVIDER, 30000L, 0L);
                dnaSdk.addMultiSign(tx, 3, (byte[][])new byte[][]{mutiSeedAct1.serializePublicKey(), mutiSeedAct2.serializePublicKey(), mutiSeedAct3.serializePublicKey()}, mutiSeedAct1);
                dnaSdk.addMultiSign(tx, 3, (byte[][])new byte[][]{mutiSeedAct1.serializePublicKey(), mutiSeedAct2.serializePublicKey(), mutiSeedAct3.serializePublicKey()}, mutiSeedAct2);
                dnaSdk.addMultiSign(tx, 3, (byte[][])new byte[][]{mutiSeedAct1.serializePublicKey(), mutiSeedAct2.serializePublicKey(), mutiSeedAct3.serializePublicKey()}, mutiSeedAct3);
                dnaSdk.addSign(tx, feeAct);
                dnaSdk.getConnect().sendRawTransaction(tx.toHexString());
                balance = dnaSdk.getConnect().getBalance(mainAccountAddr.toBase58());
                Thread.sleep(10000L);
                ExchangeDemo.printlog("++++ after claime gas ,balance of " + mainAccountAddr.toBase58() + " is " + balance);
            }
            t.join();
            t2.join();
        }
        catch (Exception e) {
            e.printStackTrace();
            ExchangeDemo.printlog("exception 3:" + e.getMessage());
        }
    }

    public static DnaSdk getDnaSdk() throws Exception {
        String ip = "http://127.0.0.1";
        String restUrl = ip + ":20334";
        String rpcUrl = ip + ":20336";
        String wsUrl = ip + ":20335";
        DnaSdk wm = DnaSdk.getInstance();
        wm.setRpc(rpcUrl);
        wm.setRestful(restUrl);
        wm.setDefaultConnect(wm.getRestful());
        String walletfile = "wallet.dat";
        wm.openWalletFile(walletfile);
        return wm;
    }

    public static void printlog(String msg) {
        System.out.println(msg);
    }

    public static UserAcct getNewUserAcct(String id, String pubkey, byte[] privkey, BigInteger ont, BigInteger gas) {
        UserAcct acct = new UserAcct();
        acct.id = id;
        acct.privkey = privkey;
        acct.address = pubkey;
        acct.gasBalance = gas;
        return acct;
    }
}

