/*
 * Decompiled with CFR 0.152.
 */
package example.signature;

import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.core.DataSignature;

public class SignatureDemo {
    public static void main(String[] args) {
        try {
            DnaSdk dnaSdk = SignatureDemo.getDnaSdk();
            Account acct = new Account(dnaSdk.defaultSignScheme);
            byte[] data = "12345".getBytes();
            byte[] signature = dnaSdk.signatureData(acct, data);
            System.out.println(dnaSdk.verifySignature(acct.serializePublicKey(), data, signature));
            acct = new Account(dnaSdk.defaultSignScheme);
            data = "12345".getBytes();
            DataSignature sign = new DataSignature(dnaSdk.defaultSignScheme, acct, data);
            byte[] signature2 = sign.signature();
            Account acct2 = new Account(false, acct.serializePublicKey());
            DataSignature sign2 = new DataSignature();
            System.out.println(sign2.verifySignature(acct2, data, signature2));
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DnaSdk getDnaSdk() throws Exception {
        String ip = "http://127.0.0.1";
        String restUrl = ip + ":20334";
        String rpcUrl = ip + ":20336";
        String wsUrl = ip + ":20335";
        DnaSdk wm = DnaSdk.getInstance();
        wm.setRpc(rpcUrl);
        wm.setRestful(restUrl);
        wm.setDefaultConnect(wm.getRestful());
        wm.openWalletFile("AccountDemo.json");
        return wm;
    }
}

