/*
 * Decompiled with CFR 0.152.
 */
package example.smartcontract;

import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.payload.DeployCode;
import com.github.DNAProject.crypto.SignatureScheme;

public class DeployCodeDemo {
    public static void main(String[] args) {
        try {
            DnaSdk dnaSdk = DeployCodeDemo.getDnaSdk();
            String password = "111111";
            String privatekey0 = "59e68b0cc387dd4e36e50c0562ff589f1d9289d32fc694b8918a3859faba6c67";
            String privatekey1 = "523c5fcf74823831756f0bcb3634234f10b3beb1c05595058534577752ad2d9f";
            Account acct0 = new Account(Helper.hexToBytes(privatekey0), dnaSdk.defaultSignScheme);
            String code = "";
            code = "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";
            System.out.println("ContractAddress:" + Address.AddressFromVmCode(code).toHexString());
            System.out.println(acct0.getAddressU160().toBase58());
            dnaSdk.vm().setCodeAddress(Address.AddressFromVmCode(code).toHexString());
            Account account = new Account(Helper.hexToBytes(privatekey1), SignatureScheme.SHA256WITHECDSA);
            DeployCode tx = dnaSdk.vm().makeDeployCodeTransaction(code, true, "name", "v1.0", "author", "email", "desp", account.getAddressU160().toBase58(), dnaSdk.DEFAULT_DEPLOY_GAS_LIMIT, 500L);
            dnaSdk.signTx(tx, new Account[][]{{account}});
            String txHex = Helper.toHexString(tx.toArray());
            System.out.println(txHex);
            Boolean result = dnaSdk.getConnect().sendRawTransaction(txHex);
            System.out.println(result);
            System.out.println("txhash:" + tx.hash().toString());
            String txhash = tx.hash().toHexString();
            Thread.sleep(6000L);
            DeployCode t = (DeployCode)dnaSdk.getConnect().getTransaction(txhash);
            System.out.println(t.txType.value() & 0xFF);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DnaSdk getDnaSdk() throws Exception {
        String ip = "http://127.0.0.1";
        String restUrl = ip + ":20334";
        String rpcUrl = ip + ":20336";
        String wsUrl = ip + ":20335";
        DnaSdk wm = DnaSdk.getInstance();
        wm.setRpc(rpcUrl);
        wm.setRestful(restUrl);
        wm.setDefaultConnect(wm.getRestful());
        wm.openWalletFile("DeployDemo.json");
        return wm;
    }
}

