/*
 * Decompiled with CFR 0.152.
 */
package example.transaction;

import com.alibaba.fastjson.JSON;
import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Common;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.crypto.SignatureScheme;
import com.github.DNAProject.sdk.wallet.Identity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;

public class CreateManyTx {
    public static String privatekey1 = "49855b16636e70f100cc5f4f42bc20a6535d7414fb8845e7310f8dd065a97221";
    public static String filePath = "txs.txt";

    public static void main(String[] args) {
        try {
            DnaSdk dnaSdk = CreateManyTx.getDnaSdk();
            Account payerAcct = new Account(Helper.hexToBytes(privatekey1), SignatureScheme.SHA256WITHECDSA);
            File file = new File(filePath);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(file);
            for (int i = 0; i < 3; ++i) {
                Account account = new Account(SignatureScheme.SHA256WITHECDSA);
                String dnaid = Common.diddna + account.getAddressU160().toBase58();
                Transaction tx = dnaSdk.nativevm().dnaId().makeRegister(dnaid, Helper.toHexString(account.serializePublicKey()), payerAcct.getAddressU160().toBase58(), 20000L, 500L);
                dnaSdk.addSign(tx, account);
                dnaSdk.addSign(tx, payerAcct);
                System.out.println("PrivateKey:" + Helper.toHexString(account.serializePrivateKey()) + ",txhash:" + tx.hash().toString());
                Identity identity = dnaSdk.getWalletMgr().createIdentityFromPriKey("password", Helper.toHexString(account.serializePrivateKey()));
                System.out.println(JSON.toJSONString((Object)identity));
                fos.write(tx.toHexString().getBytes());
                fos.write(",".getBytes());
                fos.write(tx.hash().toString().getBytes());
                fos.write("\n".getBytes());
            }
            FileReader fr = new FileReader(filePath);
            BufferedReader bf = new BufferedReader(fr);
            String txHex = null;
            while ((txHex = bf.readLine()) != null) {
                txHex = txHex.split(",")[0];
                Object obj = dnaSdk.getConnect().sendRawTransactionPreExec(txHex);
                System.out.println(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DnaSdk getDnaSdk() throws Exception {
        String ip = "http://127.0.0.1";
        String restUrl = ip + ":20334";
        String rpcUrl = ip + ":20336";
        String wsUrl = ip + ":20335";
        DnaSdk wm = DnaSdk.getInstance();
        wm.setRpc(rpcUrl);
        wm.setRestful(restUrl);
        wm.setDefaultConnect(wm.getRestful());
        wm.openWalletFile("ClaimDemo.json");
        return wm;
    }
}

