/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.config;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static final Properties CONFIG = new Properties();
    private static Path configFile;

    public static void locate(Path configPath, Path defaultConfig) {
        try {
            if (Files.notExists(configPath, new LinkOption[0])) {
                if (Files.exists(defaultConfig, new LinkOption[0])) {
                    Files.copy(defaultConfig, configPath, new CopyOption[0]);
                } else {
                    Files.createFile(configPath, new FileAttribute[0]);
                }
            }
            CONFIG.load(Files.newBufferedReader(configPath));
        }
        catch (IOException e) {
            log.error("IOException", (Throwable)e);
        }
        log.debug("Load last config: " + CONFIG.toString());
        configFile = configPath;
    }

    public static Optional<String> getProperty(String key) {
        return Optional.ofNullable(CONFIG.getProperty(key));
    }

    public static Optional<String> getProperty(Object key) {
        return Config.getProperty(key.toString());
    }

    public static String getProperty(Object key, String defaultValue) {
        return Config.getProperty(key.toString(), defaultValue);
    }

    public static String getProperty(String key, String defaultValue) {
        return Config.getProperty(key).orElse(defaultValue);
    }

    public static void setProperty(Object key, String value) {
        Config.setProperty(key.toString(), value);
    }

    public static void setProperty(String key, String value) {
        CONFIG.setProperty(key, value);
        Config.save();
    }

    public static void setIfAbsent(Object key, String value) {
        Config.setIfAbsent(key.toString(), value);
    }

    public static void setIfAbsent(String key, String value) {
        if (!Config.getProperty(key).isPresent()) {
            Config.setProperty(key, value);
        }
    }

    private static synchronized void save() {
        if (configFile == null) {
            return;
        }
        try {
            CONFIG.store(Files.newOutputStream(configFile, new OpenOption[0]), "");
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
    }
}

