/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import xdean.jex.extra.Either;

class Left<L, R>
implements Either<L, R> {
    private final L value;

    public Left(L value) {
        this.value = value;
    }

    @Override
    public boolean isLeft() {
        return true;
    }

    @Override
    public boolean isRight() {
        return false;
    }

    @Override
    public L getLeft() {
        return this.value;
    }

    @Override
    public R getRight() {
        throw new NoSuchElementException();
    }

    @Override
    public L toLeft(Function<? super R, ? extends L> f) {
        return this.value;
    }

    @Override
    public R toRight(Function<? super L, ? extends R> f) {
        return f.apply(this.value);
    }

    @Override
    public Optional<L> asLeft() {
        return Optional.of(this.value);
    }

    @Override
    public Optional<R> asRight() {
        return Optional.empty();
    }

    @Override
    public Either<L, R> ifLeft(Consumer<? super L> f) {
        f.accept(this.value);
        return this;
    }

    @Override
    public Either<L, R> ifRight(Consumer<? super R> f) {
        return this;
    }

    @Override
    public void exec(Consumer<? super L> ifLeft, Consumer<? super R> ifRight) {
        ifLeft.accept(this.value);
    }

    @Override
    public <L2> Either<L2, R> mapLeft(Function<? super L, ? extends L2> f) {
        return new Left<L2, R>(f.apply(this.value));
    }

    @Override
    public <R2> Either<L, R2> mapRight(Function<? super R, ? extends R2> f) {
        return new Left<L, R>(this.value);
    }

    @Override
    public <L2, R2> Either<L2, R2> map(Function<? super L, ? extends L2> f, Function<? super R, ? extends R2> g) {
        return new Left<L2, R>(f.apply(this.value));
    }

    @Override
    public <L2, R2> Either<L2, R2> flatMap(Function<? super L, Either<L2, R2>> f, Function<? super R, Either<L2, R2>> g) {
        return f.apply(this.value);
    }

    @Override
    public <L2> Either<L2, R> flatMapLeft(Function<? super L, Either<L2, R>> f) {
        return f.apply(this.value);
    }

    @Override
    public <R2> Either<L, R2> flatMapRight(Function<? super R, Either<L, R2>> f) {
        return new Left<L, R>(this.value);
    }

    @Override
    public <T> T unify(Function<? super L, ? extends T> f, Function<? super R, ? extends T> g) {
        return f.apply(this.value);
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public final boolean equals(Object other) {
        if (other instanceof Left) {
            Left that = (Left)other;
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public String toString() {
        return "left(" + this.value + ")";
    }
}

