/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra;

public class Pair<K, V> {
    private final K left;
    private final V right;
    private static final Pair<?, ?> EMPTY = new Pair<Object, Object>(null, null);

    public Pair(K k, V v) {
        this.left = k;
        this.right = v;
    }

    public <L> Pair<L, V> left(L left) {
        return Pair.of(left, this.right);
    }

    public <R> Pair<K, R> right(R right) {
        return Pair.of(this.left, right);
    }

    public static <K, V> Pair<K, V> of(K k, V v) {
        return new Pair<K, V>(k, v);
    }

    public static <K, V> Pair<K, V> empty() {
        return EMPTY;
    }

    public K getLeft() {
        return this.left;
    }

    public V getRight() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        if (!other.canEqual(this)) {
            return false;
        }
        K this$left = this.getLeft();
        K other$left = other.getLeft();
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        V this$right = this.getRight();
        V other$right = other.getRight();
        return !(this$right == null ? other$right != null : !this$right.equals(other$right));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pair;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        K $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        V $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        return result;
    }

    public String toString() {
        return "Pair(left=" + this.getLeft() + ", right=" + this.getRight() + ")";
    }
}

