/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra.rx;

import rx.Observable;
import rx.Subscription;

public class ObservableWrapper
implements Subscription {
    private final Observable<?> ob;
    private Subscription subscription;

    public ObservableWrapper(Observable<?> ob) {
        this.ob = ob.onErrorResumeNext(e -> {
            this.unsubscribe();
            return Observable.error((Throwable)e);
        }).doOnCompleted(() -> this.unsubscribe());
    }

    public void subscribe() {
        this.unsubscribe();
        this.subscription = this.ob.subscribe();
    }

    public void unsubscribe() {
        Subscription subscription = this.subscription;
        this.subscription = null;
        if (subscription != null && !subscription.isUnsubscribed()) {
            subscription.unsubscribe();
        }
    }

    public boolean isUnsubscribed() {
        return this.subscription == null;
    }
}

