/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra.rx;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.observables.SyncOnSubscribe;

public class ParallelReplayOnSubscribe<T>
extends SyncOnSubscribe<Integer, T> {
    private volatile List<T> list = Collections.synchronizedList(new ArrayList());
    private final AtomicInteger subscribeCount = new AtomicInteger();
    private final AtomicBoolean ended = new AtomicBoolean(false);
    private final InnerSubscriber subscriber;
    private final AtomicBoolean completed = new AtomicBoolean(false);
    private final AtomicReference<Throwable> error = new AtomicReference();

    public static <T> Observable<T> create(Observable<T> source) {
        return new ParallelReplayOnSubscribe<T>(source).create();
    }

    public Observable<T> create() {
        return Observable.create((SyncOnSubscribe)this);
    }

    public ParallelReplayOnSubscribe(Observable<T> source) {
        this.subscriber = new InnerSubscriber();
        source.subscribe((Subscriber)this.subscriber);
    }

    protected Integer generateState() {
        if (this.ended.get()) {
            throw new IllegalStateException("Can't subscribe an ended observable");
        }
        this.subscribeCount.incrementAndGet();
        return 0;
    }

    protected Integer next(Integer state, Observer<? super T> observer) {
        if (this.error.get() != null) {
            observer.onError(this.error.get());
            return -1;
        }
        if (this.list.size() == state.intValue() && this.completed.get()) {
            observer.onCompleted();
            return state;
        }
        if (this.list.size() <= state) {
            this.subscriber.requestPublic(1);
            return state;
        }
        observer.onNext(this.list.get(state));
        return state + 1;
    }

    protected void onUnsubscribe(Integer state) {
        this.subscribeCount.decrementAndGet();
    }

    @Deprecated
    public void end() {
        this.ended.compareAndSet(false, true);
    }

    private final class InnerSubscriber
    extends Subscriber<T> {
        private InnerSubscriber() {
        }

        public void onStart() {
            this.request(1L);
        }

        public void onCompleted() {
            ParallelReplayOnSubscribe.this.completed.compareAndSet(false, true);
            ParallelReplayOnSubscribe.this.list = (List)ImmutableList.copyOf((Collection)ParallelReplayOnSubscribe.this.list);
        }

        public void onError(Throwable e) {
            ParallelReplayOnSubscribe.this.error.compareAndSet(null, e);
        }

        public void onNext(T t) {
            ParallelReplayOnSubscribe.this.list.add(t);
        }

        void requestPublic(int i) {
            this.request(i);
        }
    }
}

