/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra.rx;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import rx.Observable;
import rx.Scheduler;
import rx.internal.util.RxThreadFactory;
import rx.schedulers.Schedulers;
import xdean.jex.extra.Pair;
import xdean.jex.util.lang.FinalizeSupport;

public class RxUtil {
    public static Scheduler fixedSizeScheduler(int size) {
        ExecutorService pool = Executors.newFixedThreadPool(size, (ThreadFactory)new RxThreadFactory("FixedSizeScheduler-"));
        Scheduler scheduler = Schedulers.from((Executor)pool);
        FinalizeSupport.finalize(scheduler, () -> pool.shutdown());
        return scheduler;
    }

    public static Observable<Integer> range(int from, int to, int step) {
        return Observable.range((int)0, (int)(1 + (to - from) / step)).map(i -> from + i * step);
    }

    public static Observable<Double> range(double from, double to, double step) {
        return Observable.range((int)0, (int)((int)(1.0 + (to - from) / step))).map(i -> from + (double)i.intValue() * step);
    }

    public static <A, B> Observable<Pair<A, B>> cross(Observable<A> oa, Observable<B> ob) {
        return oa.flatMap(a -> ob.map(b -> Pair.of(a, b)));
    }
}

