/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra.rx.op;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import xdean.jex.extra.Pair;

public class ContinuousGroupOperator<K, T>
implements Observable.Operator<Pair<K, List<T>>, T> {
    private final Function<T, ? extends K> keySelector;

    public Subscriber<? super T> call(Subscriber<? super Pair<K, List<T>>> s) {
        ContinuousGroupSubscriber ts = new ContinuousGroupSubscriber(s);
        s.add((Subscription)ts);
        return ts;
    }

    @ConstructorProperties(value={"keySelector"})
    public ContinuousGroupOperator(Function<T, ? extends K> keySelector) {
        this.keySelector = keySelector;
    }

    private class ContinuousGroupSubscriber
    extends Subscriber<T> {
        private final Subscriber<? super Pair<K, List<T>>> actual;
        private K key;
        private List<T> list;

        public ContinuousGroupSubscriber(Subscriber<? super Pair<K, List<T>>> actual) {
            this.actual = actual;
        }

        public void onNext(T next) {
            Object nextKey = ContinuousGroupOperator.this.keySelector.apply(next);
            if (Objects.equals(nextKey, this.key)) {
                if (this.list == null) {
                    this.list = new LinkedList();
                }
            } else {
                if (this.list != null) {
                    this.actual.onNext(Pair.of(this.key, this.list));
                }
                this.list = new ArrayList();
            }
            this.list.add(next);
            this.key = nextKey;
        }

        public void onCompleted() {
            if (this.list != null) {
                this.actual.onNext(Pair.of(this.key, new ArrayList(this.list)));
                this.list = null;
            }
            this.actual.onCompleted();
        }

        public void onError(Throwable e) {
            this.actual.onError(e);
        }
    }
}

