/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra.rx.op;

import java.beans.ConstructorProperties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;

public class ParallelOperator<T>
implements Observable.Operator<T, T> {
    private final Scheduler scheduler;

    public Subscriber<? super T> call(Subscriber<? super T> s) {
        ParallelSubscriber ts = new ParallelSubscriber(s);
        s.add((Subscription)ts);
        return ts;
    }

    @ConstructorProperties(value={"scheduler"})
    public ParallelOperator(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    private class ParallelSubscriber
    extends Subscriber<T> {
        private final Subscriber<? super T> actual;
        private final AtomicInteger endLeft = new AtomicInteger(0);
        private volatile Thread completeThread;

        public ParallelSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        public void onNext(T next) {
            this.endLeft.incrementAndGet();
            ParallelOperator.this.scheduler.createWorker().schedule(() -> {
                this.actual.onNext(next);
                if (this.endLeft.decrementAndGet() == 0 && this.completeThread != null) {
                    LockSupport.unpark(this.completeThread);
                    this.completeThread = null;
                }
            });
        }

        public void onCompleted() {
            this.completeThread = Thread.currentThread();
            LockSupport.park();
            this.actual.onCompleted();
        }

        public void onError(Throwable e) {
            this.actual.onError(e);
        }
    }
}

