/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import xdean.jex.util.cache.CacheUtil;
import xdean.jex.util.function.FunctionAdapter;

public class TimeUtil {
    public static void timeThen(Runnable r, Consumer<Long> then) {
        Stopwatch s = TimeUtil.getShareStopwatch();
        s.reset();
        s.start();
        r.run();
        s.stop();
        if (then != null) {
            then.accept(s.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    public static void timeThenPrint(Runnable r, String format) {
        TimeUtil.timeThen(r, (Long l) -> System.out.printf(format, l));
    }

    public static <T> T timeThen(Supplier<T> s, Consumer<Long> then) {
        return FunctionAdapter.supplierToRunnable(s, t -> TimeUtil.timeThen(t, then));
    }

    public static <T> T timeThenPrint(Supplier<T> r, String format) {
        return TimeUtil.timeThen(r, (Long l) -> System.out.printf(format, l));
    }

    public static void seriesTimeThen(Object uniqueKey, Runnable r, BiConsumer<Long, Long> then) {
        Stopwatch total = CacheUtil.cache(TimeUtil.class, uniqueKey, () -> Stopwatch.createUnstarted());
        Stopwatch temp = TimeUtil.getShareStopwatch();
        temp.reset();
        temp.start();
        total.start();
        r.run();
        temp.stop();
        total.stop();
        if (then != null) {
            then.accept(temp.elapsed(TimeUnit.MILLISECONDS), total.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    public static void seriesTimeThen(Runnable r, BiConsumer<Long, Long> then) {
        TimeUtil.seriesTimeThen((Object)r, r, then);
    }

    public static <T> T seriesTimeThen(Object uniqueKey, Supplier<T> s, BiConsumer<Long, Long> then) {
        return FunctionAdapter.supplierToRunnable(s, t -> TimeUtil.seriesTimeThen(uniqueKey, t, then));
    }

    public static <T> T seriesTimeThen(Supplier<T> s, BiConsumer<Long, Long> then) {
        return TimeUtil.seriesTimeThen(s, s, then);
    }

    private static Stopwatch getShareStopwatch() {
        Stopwatch share = CacheUtil.cache(TimeUtil.class, Thread.currentThread(), () -> Stopwatch.createUnstarted());
        return share.isRunning() ? Stopwatch.createUnstarted() : share;
    }
}

